/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.BindingTestSetup;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;

public abstract class ScenariosTestCase {
    @Rule
    public BindingTestSetup testSetup = new BindingTestSetup();
    private Composite composite;
    private DataBindingContext dbc;
    protected Display display;
    private boolean disposeDisplay = false;
    protected Shell shell;
    protected Text dummyText;
    protected Realm realm;

    protected Composite getComposite() {
        return this.composite;
    }

    protected DataBindingContext getDbc() {
        return this.dbc;
    }

    public Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        if (this.shell == null || this.shell.isDisposed()) {
            this.display = Display.getDefault();
            if (Display.getDefault() == null) {
                this.display = new Display();
                this.disposeDisplay = true;
            }
            this.shell = new Shell(this.display, 1264);
            this.shell.setLayout((Layout)new FillLayout());
        }
        this.shell.setText(this.getClass().getSimpleName());
        return this.shell;
    }

    protected void spinEventLoop(int secondsToWaitWithNoEvents) {
        if (!this.composite.isVisible() && secondsToWaitWithNoEvents > 0) {
            this.composite.getShell().open();
        }
        while (this.composite.getDisplay().readAndDispatch()) {
        }
        try {
            Thread.sleep(secondsToWaitWithNoEvents * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected void interact() {
        if (!this.getShell().isVisible()) {
            this.getShell().open();
        }
        while (!this.getShell().isDisposed()) {
            if (this.getShell().getDisplay().readAndDispatch()) continue;
            this.getShell().getDisplay().sleep();
        }
    }

    protected void setButtonSelectionWithEvents(Button button, boolean value) {
        if (button.getSelection() == value) {
            return;
        }
        button.setSelection(value);
        this.pushButtonWithEvents(button);
    }

    protected void pushButtonWithEvents(Button button) {
        button.notifyListeners(13, null);
    }

    @Before
    public void setUp() throws Exception {
        this.realm = DisplayRealm.getRealm((Display)Display.getDefault());
        RealmTester.setDefault((Realm)this.realm);
        this.composite = new Composite((Composite)this.getShell(), 0);
        this.composite.setLayout((Layout)new FillLayout());
        SampleData.initializeData();
        this.dbc = new DataBindingContext();
        this.dummyText = new Text(this.getComposite(), 0);
        this.dummyText.setText("dummy");
    }

    @After
    public void tearDown() throws Exception {
        this.realm = null;
        this.getShell().setVisible(false);
        this.composite.dispose();
        this.composite = null;
        if (this.shell != null) {
            this.shell.close();
            this.shell.dispose();
        } else {
            this.dbc.dispose();
        }
        if (this.display != null && this.disposeDisplay) {
            this.display.dispose();
        }
    }

    protected void enterText(Text text, String string) {
        text.notifyListeners(15, null);
        text.setText(string);
        text.notifyListeners(16, null);
    }
}

