/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableListTreeContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TreeViewer viewer;
    private Tree tree;
    private ObservableListTreeContentProvider<Object> contentProvider;
    private Object input;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.tree = new Tree((Composite)this.shell, 0);
        this.viewer = new TreeViewer(this.tree);
        this.input = new Object();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.tree = null;
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    private void initContentProvider(IObservableFactory<Object, IObservableList<Object>> listFactory) {
        this.contentProvider = new ObservableListTreeContentProvider(listFactory, null);
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.setInput(this.input);
    }

    @Test
    public void testConstructor_NullArgumentThrowsException() {
        Assert.assertThrows(AssertionFailedException.class, () -> this.initContentProvider(null));
    }

    @Test
    public void testGetElements_ChangesFollowObservedList() {
        WritableList elements = new WritableList();
        Object input = new Object();
        this.initContentProvider((IObservableFactory<Object, IObservableList<Object>>)((IObservableFactory)arg_0 -> ObservableListTreeContentProviderTest.lambda$1(input, (IObservableList)elements, arg_0)));
        Assert.assertTrue((boolean)Arrays.equals(new Object[0], this.contentProvider.getElements((Object)"unknown input")));
        Object element0 = new Object();
        elements.add(element0);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{element0}, this.contentProvider.getElements(input)));
        Object element1 = new Object();
        elements.add(element1);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{element0, element1}, this.contentProvider.getElements(input)));
    }

    @Test
    public void testViewerUpdate_RemoveElementAfterMutation() {
        WritableList children = new WritableList();
        this.initContentProvider((IObservableFactory<Object, IObservableList<Object>>)((IObservableFactory)arg_0 -> this.lambda$2((IObservableList)children, arg_0)));
        Mutable element = new Mutable();
        children.add((Object)element);
        Assert.assertEquals((long)1L, (long)this.tree.getItemCount());
        element.mutate();
        children.remove((Object)element);
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
    }

    @Test
    public void testInputChanged_ClearsKnownElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableList children = new WritableList();
        WritableList children2 = new WritableList();
        this.initContentProvider((IObservableFactory<Object, IObservableList<Object>>)((IObservableFactory)arg_0 -> this.lambda$3((IObservableList)children, input2, (IObservableList)children2, arg_0)));
        Object element = new Object();
        children.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        Assert.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput(input2);
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)knownElements);
    }

    @Test
    public void testInputChanged_ClearsRealizedElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableList children = new WritableList();
        WritableList children2 = new WritableList();
        this.initContentProvider((IObservableFactory<Object, IObservableList<Object>>)((IObservableFactory)arg_0 -> this.lambda$4((IObservableList)children, input2, (IObservableList)children2, arg_0)));
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        children.add(element);
        Assert.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput(input2);
        Assert.assertEquals(Collections.emptySet(), (Object)realizedElements);
    }

    private static /* synthetic */ IObservableList lambda$1(Object object, IObservableList iObservableList, Object target) {
        return target == object ? iObservableList : null;
    }

    private /* synthetic */ IObservableList lambda$2(IObservableList iObservableList, Object target) {
        return target == this.input ? iObservableList : null;
    }

    private /* synthetic */ IObservableList lambda$3(IObservableList iObservableList, Object object, IObservableList iObservableList2, Object target) {
        if (target == this.input) {
            return iObservableList;
        }
        if (target == object) {
            return iObservableList2;
        }
        return null;
    }

    private /* synthetic */ IObservableList lambda$4(IObservableList iObservableList, Object object, IObservableList iObservableList2, Object target) {
        if (target == this.input) {
            return iObservableList;
        }
        if (target == object) {
            return iObservableList2;
        }
        return null;
    }

    static class Mutable {
        private int id;

        public Mutable() {
            this(0);
        }

        public Mutable(int id) {
            this.id = id;
        }

        public void mutate() {
            ++this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

