/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableSetContentProviderTest
extends AbstractSWTTestCase {
    private Shell shell;
    private TableViewer viewer;
    private ObservableSetContentProvider<Object> contentProvider;
    private IObservableSet<Object> input;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TableViewer((Composite)this.shell, 0);
        this.contentProvider = new ObservableSetContentProvider();
        this.viewer.setContentProvider(this.contentProvider);
        this.input = new WritableSet();
        this.viewer.setInput(this.input);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    @Test
    public void testKnownElements_Realm() throws Exception {
        Assert.assertSame((String)"realm for the known elements should be the SWT realm", (Object)DisplayRealm.getRealm((Display)Display.getDefault()), (Object)this.contentProvider.getKnownElements().getRealm());
    }

    @Test
    public void testRealizedElements_Realm() {
        Assert.assertSame((String)"realm for the realized elements should be the SWT realm", (Object)DisplayRealm.getRealm((Display)Display.getDefault()), (Object)this.contentProvider.getRealizedElements().getRealm());
    }

    @Test
    public void testKnownElementsAfterSetInput() {
        Assert.assertEquals((long)0L, (long)this.contentProvider.getKnownElements().size());
        HashSet<String> newElements = new HashSet<String>(Arrays.asList("one", "two", "three"));
        WritableSet newInput = new WritableSet();
        newInput.addAll(newElements);
        this.viewer.setInput((Object)newInput);
        Assert.assertEquals(newElements, (Object)this.contentProvider.getKnownElements());
    }

    @Test
    public void testViewerUpdate_RemoveElementAfterMutation() {
        Mutable element = new Mutable(1);
        this.input.add((Object)element);
        Assert.assertEquals((long)1L, (long)this.viewer.getTable().getItemCount());
        ++element.id;
        this.input.clear();
        Assert.assertEquals((long)0L, (long)this.viewer.getTable().getItemCount());
    }

    @Test
    public void testInputChanged_ClearsKnownElements() {
        Object element = new Object();
        this.input.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        Assert.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput((Object)Observables.emptyObservableSet());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)knownElements);
    }

    @Test
    public void testInputChanged_ClearsRealizedElements() {
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        this.input.add(element);
        Assert.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput((Object)Observables.emptyObservableSet());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)realizedElements);
    }

    static class Mutable {
        public int id;

        public Mutable(int id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

