/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ObservableViewerElementSet;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableSetTreeContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TreeViewer viewer;
    private Tree tree;
    private ObservableSetTreeContentProvider<Object> contentProvider;
    private Object input;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.tree = new Tree((Composite)this.shell, 0);
        this.viewer = new TreeViewer(this.tree);
        this.input = new Object();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
        this.tree = null;
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    private void initContentProvider(IObservableFactory<Object, IObservableSet<Object>> listFactory) {
        this.contentProvider = new ObservableSetTreeContentProvider(listFactory, null);
        this.viewer.setContentProvider(this.contentProvider);
        this.viewer.setInput(this.input);
    }

    @Test
    public void testConstructor_NullArgumentThrowsException() {
        Assert.assertThrows(AssertionFailedException.class, () -> this.initContentProvider(null));
    }

    @Test
    public void testGetElements_ChangesFollowObservedList() {
        WritableSet elements = new WritableSet();
        Object input = new Object();
        this.initContentProvider((IObservableFactory<Object, IObservableSet<Object>>)((IObservableFactory)arg_0 -> ObservableSetTreeContentProviderTest.lambda$1(input, (IObservableSet)elements, arg_0)));
        Assert.assertTrue((boolean)Arrays.equals(new Object[0], this.contentProvider.getElements((Object)"unknown input")));
        Object element0 = new Object();
        elements.add(element0);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{element0}, this.contentProvider.getElements(input)));
        Object element1 = new Object();
        elements.add(element1);
        List<Object> elementList = List.of(this.contentProvider.getElements(input));
        Assert.assertEquals((long)2L, (long)elementList.size());
        Assert.assertTrue((boolean)elementList.containsAll(List.of(element0, element1)));
    }

    @Test
    public void testViewerUpdate_RemoveElementAfterMutation() {
        IElementComparer comparer = new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }
        };
        this.viewer.setComparer(comparer);
        IObservableSet children = ObservableViewerElementSet.withComparer((Realm)Realm.getDefault(), null, (IElementComparer)comparer);
        this.initContentProvider((IObservableFactory<Object, IObservableSet<Object>>)((IObservableFactory)target -> target == this.input ? children : null));
        Mutable element = new Mutable();
        children.add((Object)element);
        Assert.assertEquals((long)1L, (long)this.tree.getItemCount());
        element.mutate();
        Assert.assertTrue((boolean)children.remove((Object)element));
        Assert.assertEquals((long)0L, (long)this.tree.getItemCount());
    }

    @Test
    public void testInputChanged_ClearsKnownElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableSet children = new WritableSet();
        WritableSet children2 = new WritableSet();
        this.initContentProvider((IObservableFactory<Object, IObservableSet<Object>>)((IObservableFactory)arg_0 -> this.lambda$3((IObservableSet)children, input2, (IObservableSet)children2, arg_0)));
        Object element = new Object();
        children.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        Assert.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput(input2);
        Assert.assertEquals(Collections.emptySet(), (Object)knownElements);
    }

    @Test
    public void testInputChanged_ClearsRealizedElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableSet children = new WritableSet();
        WritableSet children2 = new WritableSet();
        this.initContentProvider((IObservableFactory<Object, IObservableSet<Object>>)((IObservableFactory)arg_0 -> this.lambda$4((IObservableSet)children, input2, (IObservableSet)children2, arg_0)));
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        children.add(element);
        Assert.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput(input2);
        Assert.assertEquals(Collections.emptySet(), (Object)realizedElements);
    }

    private static /* synthetic */ IObservableSet lambda$1(Object object, IObservableSet iObservableSet, Object target) {
        return target == object ? iObservableSet : null;
    }

    private /* synthetic */ IObservableSet lambda$3(IObservableSet iObservableSet, Object object, IObservableSet iObservableSet2, Object target) {
        if (target == this.input) {
            return iObservableSet;
        }
        if (target == object) {
            return iObservableSet2;
        }
        return null;
    }

    private /* synthetic */ IObservableSet lambda$4(IObservableSet iObservableSet, Object object, IObservableSet iObservableSet2, Object target) {
        if (target == this.input) {
            return iObservableSet;
        }
        if (target == object) {
            return iObservableSet2;
        }
        return null;
    }

    static class Mutable {
        private int id;

        public Mutable() {
            this(0);
        }

        public Mutable(int id) {
            this.id = id;
        }

        public void mutate() {
            ++this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

