/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.examples.databinding.mask.internal;

import org.eclipse.jface.examples.databinding.mask.EditMaskParseException;
import org.eclipse.jface.examples.databinding.mask.internal.EditMaskParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EditMaskParserTest {
    private EditMaskParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new EditMaskParser("(###) ###-####");
    }

    @Test
    public void testEditMaskParser_validMask() {
        new EditMaskParser("(###) ###-####");
    }

    @Test
    public void testEditMaskParser_invalidMask() {
        Assert.assertThrows(EditMaskParseException.class, () -> {
            EditMaskParser editMaskParser = new EditMaskParser("(###) ###-####\\");
        });
    }

    @Test
    public void testSetInput() {
        this.parser.setInput("63a0) 5*55-1\\212abc9");
        Assert.assertEquals((String)"Unformatted input", (Object)"6305551212", (Object)this.parser.getRawResult());
        Assert.assertEquals((String)"Formatted input", (Object)"(630) 555-1212", (Object)this.parser.getFormattedResult());
    }

    @Test
    public void testSetInput_incomplete() {
        this.parser.setInput("6a0) 5*5-1\\12");
        Assert.assertEquals((String)"Unformatted input", (Object)"6055112", (Object)this.parser.getRawResult());
        Assert.assertEquals((String)"Formatted input", (Object)"(605) 511-2   ", (Object)this.parser.getFormattedResult());
    }

    @Test
    public void testIsComplete() {
        this.parser.setInput("63a0) 5*55-1\\212");
        Assert.assertTrue((String)"complete", (boolean)this.parser.isComplete());
        this.parser.setInput("6a0) 5*5-1\\12");
        Assert.assertFalse((String)"incomplete", (boolean)this.parser.isComplete());
    }

    @Test
    public void testSetPlaceholder() throws Exception {
        this.parser.setInput("6a0) 5*5-1\\12");
        Assert.assertEquals((String)"Formatted input", (Object)"(605) 511-2   ", (Object)this.parser.getFormattedResult());
        this.parser.setPlaceholder('_');
        Assert.assertEquals((String)"Formatted input", (Object)"(605) 511-2___", (Object)this.parser.getFormattedResult());
    }

    @Test
    public void testGetNextInputPosition() {
        Assert.assertEquals((String)"Skip leading (", (long)1L, (long)this.parser.getNextInputPosition(0));
        Assert.assertEquals((String)"Position 1 is good", (long)1L, (long)this.parser.getNextInputPosition(1));
        Assert.assertEquals((String)"Skip )<space>", (long)6L, (long)this.parser.getNextInputPosition(4));
    }

    @Test
    public void testGetFirstIncompleteInputPosition() throws Exception {
        Assert.assertEquals((String)"1st position incomplete", (long)1L, (long)this.parser.getFirstIncompleteInputPosition());
        this.parser.setInput("6a0) 5*5-1\\12");
        Assert.assertEquals((String)"11th position incomplete", (long)11L, (long)this.parser.getFirstIncompleteInputPosition());
        this.parser.setInput("63a0) 5*55-1\\212");
        Assert.assertEquals((String)"all complete", (long)-1L, (long)this.parser.getFirstIncompleteInputPosition());
    }
}

