/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.swt.SWTObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CComboObservableValueTextTest {
    private Delegate delegate;
    private CCombo combo;

    @Before
    public void setUp() throws Exception {
        this.delegate = new Delegate();
        this.delegate.setUp();
        this.combo = this.delegate.combo;
    }

    @After
    public void tearDown() throws Exception {
        this.delegate.tearDown();
    }

    @Test
    public void testModify_NotifiesObservable() throws Exception {
        IObservableValue observable = this.delegate.createObservableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        this.combo.setText((String)this.delegate.createValue(observable));
        Assert.assertEquals((String)"Observable was not notified.", (long)1L, (long)listener.count);
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(SWTMutableObservableValueContractTest.class, (Object)new Delegate());
        suite.addTest(SWTObservableValueContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        CCombo combo;
        private Shell shell;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.combo = new CCombo((Composite)this.shell, 0);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.combo);
        }

        public void change(IObservable observable) {
            IObservableValue ov = (IObservableValue)observable;
            ov.setValue(this.createValue(ov));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return String.valueOf(observable.getValue()) + "a";
        }
    }
}

