/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DateTimeCalendarObservableValueTest
extends AbstractSWTTestCase {
    private DateTime dateTime;
    private IObservableValue dateObservable;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dateTime = new DateTime((Composite)this.getShell(), 1024);
        this.dateObservable = WidgetProperties.dateTimeSelection().observe((Widget)this.dateTime);
    }

    @Test
    public void testGetValue_ExcludesTimeComponent() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int epochHour = calendar.get(11);
        int epochMinute = calendar.get(12);
        int epochSecond = calendar.get(13);
        int epochMillisecond = calendar.get(14);
        calendar.set(2009, 3, 3, 12, 7, 21);
        this.dateObservable.setValue((Object)calendar.getTime());
        calendar.setTime((Date)this.dateObservable.getValue());
        Assert.assertEquals((long)2009L, (long)calendar.get(1));
        Assert.assertEquals((long)3L, (long)calendar.get(2));
        Assert.assertEquals((long)3L, (long)calendar.get(5));
        Assert.assertEquals((long)epochHour, (long)calendar.get(11));
        Assert.assertEquals((long)epochMinute, (long)calendar.get(12));
        Assert.assertEquals((long)epochSecond, (long)calendar.get(13));
        Assert.assertEquals((long)epochMillisecond, (long)calendar.get(14));
    }
}

