/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import java.time.LocalDate;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class LocalDateSelectionPropertyTest
extends AbstractSWTTestCase {
    @Test
    public void testSetInObservable() {
        DateTime control = new DateTime((Composite)this.getShell(), 32);
        ISWTObservableValue time = WidgetProperties.localDateSelection().observe((Widget)control);
        ValueChangeEventTracker tracker = new ValueChangeEventTracker();
        time.addValueChangeListener((IValueChangeListener)tracker);
        time.setValue((Object)LocalDate.of(1999, 11, 22));
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((long)1999L, (long)control.getYear());
        Assert.assertEquals((long)10L, (long)control.getMonth());
        Assert.assertEquals((long)22L, (long)control.getDay());
    }

    @Test
    public void testSetInControl() {
        DateTime control = new DateTime((Composite)this.getShell(), 32);
        ISWTObservableValue time = WidgetProperties.localDateSelection().observe((Widget)control);
        ValueChangeEventTracker tracker = new ValueChangeEventTracker();
        time.addValueChangeListener((IValueChangeListener)tracker);
        control.setDate(1999, 10, 22);
        control.notifyListeners(13, null);
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)LocalDate.of(1999, 11, 22), (Object)time.getValue());
    }

    @Test
    public void testWrongKind() {
        DateTime control = new DateTime((Composite)this.getShell(), 128);
        ISWTObservableValue time = WidgetProperties.localDateSelection().observe((Widget)control);
        Assert.assertThrows(IllegalStateException.class, () -> LocalDateSelectionPropertyTest.lambda$0((IObservableValue)time));
    }

    @Test
    public void testNullNotThrowingNullPointerException() {
        DateTime control = new DateTime((Composite)this.getShell(), 32);
        WidgetProperties.localDateSelection().setValue((Object)control, null);
    }

    @Test
    public void testType() {
        Assert.assertEquals(LocalDate.class, (Object)WidgetProperties.localDateSelection().getValueType());
    }

    private static /* synthetic */ void lambda$0(IObservableValue iObservableValue) throws Throwable {
        iObservableValue.setValue((Object)LocalDate.of(1999, 11, 22));
    }
}

