/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import java.time.LocalTime;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class LocalTimeSelectionProperty
extends AbstractSWTTestCase {
    @Test
    public void testSetInObservable() {
        DateTime control = new DateTime((Composite)this.getShell(), 128);
        ISWTObservableValue time = WidgetProperties.localTimeSelection().observe((Widget)control);
        ValueChangeEventTracker tracker = new ValueChangeEventTracker();
        time.addValueChangeListener((IValueChangeListener)tracker);
        time.setValue((Object)LocalTime.of(11, 22, 33));
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((long)11L, (long)control.getHours());
        Assert.assertEquals((long)22L, (long)control.getMinutes());
        Assert.assertEquals((long)33L, (long)control.getSeconds());
    }

    @Test
    public void testSetInControl() {
        DateTime control = new DateTime((Composite)this.getShell(), 128);
        ISWTObservableValue time = WidgetProperties.localTimeSelection().observe((Widget)control);
        ValueChangeEventTracker tracker = new ValueChangeEventTracker();
        time.addValueChangeListener((IValueChangeListener)tracker);
        control.setHours(11);
        control.setMinutes(22);
        control.setSeconds(33);
        control.notifyListeners(13, null);
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertEquals((Object)LocalTime.of(11, 22, 33), (Object)time.getValue());
    }

    @Test
    public void testWrongKind() {
        DateTime control = new DateTime((Composite)this.getShell(), 32);
        ISWTObservableValue time = WidgetProperties.localTimeSelection().observe((Widget)control);
        Assert.assertThrows(IllegalStateException.class, () -> LocalTimeSelectionProperty.lambda$0((IObservableValue)time));
    }

    @Test
    public void testType() {
        Assert.assertEquals(LocalTime.class, (Object)WidgetProperties.localTimeSelection().getValueType());
    }

    @Test
    public void testNullNotThrowingNullPointerException() {
        DateTime control = new DateTime((Composite)this.getShell(), 128);
        WidgetProperties.localTimeSelection().setValue((Object)control, null);
    }

    private static /* synthetic */ void lambda$0(IObservableValue iObservableValue) throws Throwable {
        iObservableValue.setValue((Object)LocalTime.of(11, 11, 11));
    }
}

