/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.swt.SWTObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableSingleSelectionObservableValueTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private IObservableValue observable;
    private Table table;

    public TableSingleSelectionObservableValueTest() {
        super((IObservableContractDelegate)new Delegate());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.observable = (IObservableValue)this.getObservable();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.table = this.delegate.table;
    }

    protected IObservable doCreateObservable() {
        Delegate delegate = (Delegate)this.getObservableContractDelegate();
        return delegate.createObservableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    @Test
    public void testSetValue() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.table.getSelectionIndex());
        Assert.assertEquals((long)-1L, (long)((Integer)this.observable.getValue()).intValue());
        Integer value = 0;
        this.observable.setValue((Object)value);
        Assert.assertEquals((String)"table selection index", (long)value.intValue(), (long)this.table.getSelectionIndex());
        Assert.assertEquals((String)"observable value", (Object)value, (Object)this.observable.getValue());
    }

    @Test
    public void testGetValue() throws Exception {
        int value = 1;
        this.table.setSelection(value);
        Assert.assertEquals((String)"table selection index", (long)value, (long)this.table.getSelectionIndex());
        Assert.assertEquals((String)"observable value", (Object)value, (Object)this.observable.getValue());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(SWTMutableObservableValueContractTest.class, (Object)new Delegate());
        suite.addTest(SWTObservableValueContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Table table;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.table = new Table((Composite)this.shell, 0);
            new TableItem(this.table, 0).setText("0");
            new TableItem(this.table, 0).setText("1");
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.singleSelectionIndex().observe(realm, (Object)this.table);
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public void change(IObservable observable) {
            int index = this.createIntegerValue((IObservableValue)observable);
            this.table.select(index);
            this.table.notifyListeners(13, null);
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            int value = (Integer)observable.getValue();
            switch (value) {
                case -1: 
                case 1: {
                    return 0;
                }
                case 0: {
                    return 1;
                }
            }
            org.eclipse.core.runtime.Assert.isTrue((boolean)false);
            return null;
        }
    }
}

