/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.swt.SWTObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextEditableObservableValueTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private Text text;
    private IObservableValue observable;

    public TextEditableObservableValueTest() {
        super((IObservableContractDelegate)new Delegate());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.text = this.delegate.text;
    }

    protected IObservable doCreateObservable() {
        return super.doCreateObservable();
    }

    @Test
    public void testGetValue() throws Exception {
        this.text.setEditable(false);
        Assert.assertEquals((Object)this.text.getEditable(), (Object)this.observable.getValue());
        this.text.setEditable(true);
        Assert.assertEquals((Object)this.text.getEditable(), (Object)this.observable.getValue());
    }

    @Test
    public void testSetValue() throws Exception {
        this.text.setEditable(false);
        this.observable.setValue((Object)Boolean.TRUE);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)this.text.getEditable());
        this.observable.setValue((Object)Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)this.text.getEditable());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(SWTMutableObservableValueContractTest.class, (Object)new Delegate());
        suite.addTest(SWTObservableValueContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Text text;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.text = new Text((Composite)this.shell, 0);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.editable().observe(realm, (Object)this.text);
        }

        public Object getValueType(IObservableValue observable) {
            return Boolean.TYPE;
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object createValue(IObservableValue observable) {
            return Boolean.TRUE.equals(observable.getValue()) ? Boolean.FALSE : Boolean.TRUE;
        }
    }
}

