/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.swt.SWTObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class TextObservableValueFocusOutTest
extends AbstractSWTTestCase {
    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(SWTMutableObservableValueContractTest.class, (Object)new Delegate());
        suite.addTest(SWTObservableValueContractTest.class, (Object)new Delegate());
    }

    @Test
    public void testIsStale_AfterModifyBeforeFocusOut() {
        Text text = new Text((Composite)this.getShell(), 0);
        text.setText("0");
        ISWTObservableValue observable = WidgetProperties.text((int)16).observe((Widget)text);
        StaleEventTracker staleTracker = StaleEventTracker.observe((IObservable)observable);
        ChangeEventTracker changeTracker = ChangeEventTracker.observe((IObservable)observable);
        Assert.assertFalse((boolean)observable.isStale());
        Assert.assertEquals((long)0L, (long)staleTracker.count);
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        text.setText("1");
        text.notifyListeners(24, null);
        Assert.assertTrue((boolean)observable.isStale());
        Assert.assertEquals((long)1L, (long)staleTracker.count);
        Assert.assertEquals((long)0L, (long)changeTracker.count);
        text.notifyListeners(16, null);
        Assert.assertFalse((boolean)observable.isStale());
        Assert.assertEquals((long)1L, (long)staleTracker.count);
        Assert.assertEquals((long)1L, (long)changeTracker.count);
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        private Text text;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.text = new Text((Composite)this.shell, 0);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text((int)16).observe(realm, (Object)this.text);
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public void change(IObservable observable) {
            this.text.setFocus();
            IObservableValue observableValue = (IObservableValue)observable;
            this.text.setText((String)this.createValue(observableValue));
            this.text.notifyListeners(16, null);
        }

        public Object createValue(IObservableValue observable) {
            String value = (String)observable.getValue();
            return value + "a";
        }
    }
}

