/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextObservableValueTest
extends AbstractDefaultRealmTestCase {
    private Text text;
    private ValueChangeEventTracker listener;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Shell shell = new Shell();
        this.text = new Text((Composite)shell, 0);
        this.listener = new ValueChangeEventTracker();
    }

    @Test
    public void testConstructorUpdateEventTypes() {
        WidgetProperties.text((int)0);
        WidgetProperties.text((int)16);
        WidgetProperties.text((int)24);
        WidgetProperties.text((int)14);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IWidgetValueProperty iWidgetValueProperty = WidgetProperties.text((int)25);
        });
    }

    @Test
    public void testGetValueBeforeFocusOutChangeEventsFire() throws Exception {
        IObservableValue observableValue = WidgetProperties.text((int)16).observe(Realm.getDefault(), (Object)this.text);
        observableValue.addValueChangeListener((IValueChangeListener)this.listener);
        String a = "a";
        String b = "b";
        this.text.setText(a);
        Assert.assertEquals((long)0L, (long)this.listener.count);
        Assert.assertEquals((Object)a, (Object)observableValue.getValue());
        Assert.assertEquals((long)1L, (long)this.listener.count);
        this.text.setText(b);
        Assert.assertEquals((long)1L, (long)this.listener.count);
        this.text.notifyListeners(16, null);
        Assert.assertEquals((long)2L, (long)this.listener.count);
        Assert.assertEquals((Object)a, (Object)this.listener.event.diff.getOldValue());
        Assert.assertEquals((Object)b, (Object)this.listener.event.diff.getNewValue());
    }

    @Test
    public void testDispose() throws Exception {
        IObservableValue observableValue = WidgetProperties.text((int)24).observe(Realm.getDefault(), (Object)this.text);
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        String expected1 = "Test123";
        this.text.setText(expected1);
        Assert.assertEquals((long)1L, (long)testCounterValueChangeListener.count);
        Assert.assertEquals((Object)expected1, (Object)this.text.getText());
        Assert.assertEquals((Object)expected1, (Object)observableValue.getValue());
        observableValue.dispose();
        String expected2 = "NewValue123";
        this.text.setText(expected2);
        Assert.assertEquals((long)1L, (long)testCounterValueChangeListener.count);
        Assert.assertEquals((Object)expected2, (Object)this.text.getText());
    }
}

