/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import java.util.function.Function;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.swt.SWTObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Test;

public class VisibleTest
extends AbstractDefaultRealmTestCase {
    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(SWTMutableObservableValueContractTest.class, new Delegate<Shell>(shell -> shell));
        suite.addTest(SWTMutableObservableValueContractTest.class, new Delegate<Menu>(Menu::new));
        suite.addTest(SWTMutableObservableValueContractTest.class, new Delegate<ToolTip>(shell -> new ToolTip(shell, 4096)));
        suite.addTest(SWTMutableObservableValueContractTest.class, new Delegate<ToolBar>(shell -> new ToolBar((Composite)shell, 256)));
        suite.addTest(SWTMutableObservableValueContractTest.class, new Delegate<ScrollBar>(Scrollable::getHorizontalBar));
        suite.addTest(SWTObservableValueContractTest.class, new Delegate<Shell>(shell -> shell));
        suite.addTest(SWTObservableValueContractTest.class, new Delegate<Menu>(Menu::new));
        suite.addTest(SWTObservableValueContractTest.class, new Delegate<ToolTip>(shell -> new ToolTip(shell, 4096)));
        suite.addTest(SWTObservableValueContractTest.class, new Delegate<ToolBar>(shell -> new ToolBar((Composite)shell, 256)));
        suite.addTest(SWTObservableValueContractTest.class, new Delegate<ScrollBar>(Scrollable::getHorizontalBar));
    }

    @Test
    public void testUnsupportedWidget() {
        Tracker tracker = new Tracker((Composite)new Shell(), 0);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            ISWTObservableValue iSWTObservableValue = WidgetProperties.visible().observe((Widget)tracker);
        });
    }

    static class Delegate<W extends Widget>
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        private W widget;
        private final Function<Shell, W> widgetFactory;

        public Delegate(Function<Shell, W> widgetFactory) {
            this.widgetFactory = widgetFactory;
        }

        public void setUp() {
            this.shell = new Shell(256);
            this.widget = (Widget)this.widgetFactory.apply(this.shell);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue<?> createObservableValue(Realm realm) {
            return WidgetProperties.visible().observe(realm, this.widget);
        }

        public void change(IObservable observable) {
            IObservableValue value;
            value.setValue((Object)((Boolean)(value = (IObservableValue)observable).getValue() == false ? 1 : 0));
        }

        public Object getValueType(IObservableValue<?> observable) {
            return Boolean.class;
        }

        public Object createValue(IObservableValue<?> observable) {
            return (Boolean)observable.getValue() == false;
        }
    }
}

