/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IElementComparer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ViewerElementSetTest {
    IdentityElementComparer comparer;
    ViewerElementSet set;

    @Before
    public void setUp() throws Exception {
        this.comparer = new IdentityElementComparer();
        this.set = new ViewerElementSet((IElementComparer)this.comparer);
    }

    @Test
    public void testConstructor_NullComparer() {
        Assert.assertThrows((String)"Constructor should throw exception when null comparer passed in", RuntimeException.class, () -> {
            ViewerElementSet viewerElementSet = new ViewerElementSet(null);
        });
    }

    @Test
    public void testConstructorWithCollection_NullCollection() {
        Assert.assertThrows((String)"Constructor should throw exception when null collection passed in", RuntimeException.class, () -> {
            ViewerElementSet viewerElementSet = new ViewerElementSet(null, (IElementComparer)new IdentityElementComparer());
        });
    }

    @Test
    public void testConstructorWithCollection_AddsAllElements() {
        Set<Object> toCopy = Collections.singleton(new Object());
        this.set = new ViewerElementSet(toCopy, (IElementComparer)new IdentityElementComparer());
        Assert.assertTrue((boolean)this.set.containsAll(toCopy));
    }

    @Test
    public void testAdd_ContainsHonorsComparer() {
        String o1 = new String("string");
        String o2 = new String("string");
        Assert.assertTrue((boolean)o1.equals(o2));
        Assert.assertNotSame((Object)o1, (Object)o2);
        Assert.assertTrue((boolean)this.set.add((Object)o1));
        Assert.assertTrue((boolean)this.set.contains((Object)o1));
        Assert.assertFalse((boolean)this.set.contains((Object)o2));
    }

    @Test
    public void testAdd_FilterDuplicateElements() {
        Object o = new Object();
        Assert.assertTrue((boolean)this.set.add(o));
        Assert.assertFalse((boolean)this.set.add(o));
        Assert.assertEquals((long)1L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.contains(o));
    }

    @Test
    public void testAddAll_ContainsAllHonorsComparer() {
        String o1 = new String("o1");
        String o2 = new String("o2");
        List<String> items = List.of(o1, o2);
        Assert.assertTrue((boolean)this.set.addAll(items));
        Assert.assertTrue((boolean)this.set.containsAll(items));
        Assert.assertFalse((boolean)this.set.containsAll(Collections.singleton(new String("o1"))));
        Assert.assertFalse((boolean)this.set.containsAll(Collections.singleton(new String("o2"))));
    }

    @Test
    public void testAddAll_FiltersDuplicateElements() {
        Object o = new Object();
        this.set.add(o);
        Assert.assertFalse((boolean)this.set.addAll(Collections.singleton(o)));
    }

    @Test
    public void testClear() {
        this.set.add(new Object());
        Assert.assertEquals((long)1L, (long)this.set.size());
        this.set.clear();
        Assert.assertEquals((long)0L, (long)this.set.size());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.set.isEmpty());
        this.set.add(new Object());
        Assert.assertFalse((boolean)this.set.isEmpty());
    }

    @Test
    public void testIterator() {
        Object o = new Object();
        this.set.add(o);
        Iterator iterator = this.set.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertSame((Object)o, iterator.next());
        Assert.assertTrue((boolean)this.set.contains(o));
        iterator.remove();
        Assert.assertFalse((boolean)this.set.contains(o));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testRemove() {
        Object o = new Object();
        Assert.assertFalse((boolean)this.set.remove(o));
        Assert.assertTrue((boolean)this.set.add(o));
        Assert.assertTrue((boolean)this.set.contains(o));
        Assert.assertTrue((boolean)this.set.remove(o));
        Assert.assertFalse((boolean)this.set.contains(o));
    }

    @Test
    public void testRemoveAll() {
        Assert.assertFalse((boolean)this.set.removeAll(Collections.emptySet()));
        Object o1 = new Object();
        Object o2 = new Object();
        this.set.addAll(List.of(o1, o2));
        Assert.assertTrue((boolean)this.set.removeAll(Collections.singleton(o1)));
        Assert.assertFalse((boolean)this.set.contains(o1));
        Assert.assertFalse((boolean)this.set.removeAll(Collections.singleton(o1)));
        Assert.assertTrue((boolean)this.set.removeAll(List.of(o2, "some", "other", "objects")));
        Assert.assertFalse((boolean)this.set.contains(o2));
    }

    @Test
    public void testRetainAll() {
        Object o1 = new Object();
        Object o2 = new Object();
        this.set.add(o1);
        this.set.add(o2);
        Assert.assertFalse((boolean)this.set.retainAll(List.of(o1, o2)));
        Assert.assertTrue((boolean)this.set.contains(o2));
        Assert.assertTrue((boolean)this.set.retainAll(Collections.singleton(o1)));
        Assert.assertFalse((boolean)this.set.contains(o2));
        Assert.assertTrue((boolean)this.set.contains(o1));
        Assert.assertTrue((boolean)this.set.retainAll(Collections.emptySet()));
        Assert.assertFalse((boolean)this.set.contains(o1));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.set.size());
        Object o = new Object();
        this.set.add(o);
        Assert.assertEquals((long)1L, (long)this.set.size());
        this.set.remove(o);
        Assert.assertEquals((long)0L, (long)this.set.size());
    }

    @Test
    public void testToArray() {
        Assert.assertEquals((long)0L, (long)this.set.toArray().length);
        Object o = new Object();
        this.set.add(o);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{o}, this.set.toArray()));
    }

    @Test
    public void testToArrayWithObjectArray() {
        String o = new String("unique");
        this.set.add((Object)o);
        String[] array = (String[])this.set.toArray((Object[])new String[0]);
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertSame((Object)o, (Object)array[0]);
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.set.equals((Object)this.set));
        Assert.assertFalse((boolean)this.set.equals(null));
        Assert.assertFalse((boolean)this.set.equals(new Object()));
        Assert.assertTrue((boolean)this.set.equals(Collections.emptySet()));
        String o = new String("string");
        String distinct = new String("string");
        this.set.add((Object)o);
        Assert.assertTrue((boolean)this.set.equals(Collections.singleton(o)));
        Assert.assertFalse((boolean)this.set.equals(Collections.singleton(distinct)));
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)0L, (long)this.set.hashCode());
        Object o = new Object();
        this.set.add(o);
        int hash = this.comparer.hashCode(o);
        Assert.assertEquals((long)hash, (long)this.set.hashCode());
        Object o2 = new Object();
        this.set.add(o2);
        Assert.assertEquals((long)(hash += this.comparer.hashCode(o2)), (long)this.set.hashCode());
    }

    static class IdentityElementComparer
    implements IElementComparer {
        IdentityElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object element) {
            return System.identityHashCode(element);
        }
    }
}

