/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.tests;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.text.quicksearch.internal.core.priority.DefaultPriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultPriorityFunctionTest {
    private DefaultPriorityFunction fPriorityFunction;

    @Before
    public void setup() {
        this.fPriorityFunction = new DefaultPriorityFunction();
        this.fPriorityFunction.configure(QuickSearchActivator.getDefault().getPreferences());
    }

    @Test
    public void testIgnoreLinkedContainers() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject p1 = root.getProject("p1");
        p1.create(null);
        p1.open(null);
        IProject p2 = root.getProject("p2");
        p2.create(null);
        p2.open(null);
        IFolder f1 = p1.getFolder("f1");
        f1.create(true, true, null);
        IFolder linkedp1 = p2.getFolder("p1");
        linkedp1.createLink(p1.getLocationURI(), 0, null);
        IFolder linkedF1 = p2.getFolder("f1");
        linkedF1.createLink(f1.getLocationURI(), 0, null);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)this.fPriorityFunction.priority((IResource)linkedp1), (double)1.0);
        Assert.assertNotEquals((double)Double.NEGATIVE_INFINITY, (double)this.fPriorityFunction.priority((IResource)p1), (double)1.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)this.fPriorityFunction.priority((IResource)linkedF1), (double)1.0);
        Assert.assertNotEquals((double)Double.NEGATIVE_INFINITY, (double)this.fPriorityFunction.priority((IResource)f1), (double)1.0);
    }

    @Test
    public void testDoNotIgnoreVirtualFolder() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject p3 = root.getProject("p3");
        p3.create(null);
        p3.open(null);
        IFolder f2 = p3.getFolder("f2");
        f2.create(8192, true, null);
        Assert.assertNotEquals((double)Double.NEGATIVE_INFINITY, (double)this.fPriorityFunction.priority((IResource)f2), (double)1.0);
    }
}

