/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.tests;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.text.quicksearch.internal.core.priority.PrioriTree;
import org.eclipse.text.quicksearch.tests.MockResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrioriTreeTest {
    PrioriTree tree;

    @Before
    public void setUp() throws Exception {
        this.tree = PrioriTree.create();
    }

    @Test
    public void testWithEmptyTree() {
        this.checkPriority(0.0, "/");
        this.checkPriority(0.0, "/foo/bar/zor");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/foo/muck.zip");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/muck.jar");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/images/muck.jpg");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/project/.git");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/project/target");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/project/build");
    }

    @Test
    public void testSinglePathSet() {
        this.setPriority("/foo/bar/zor", 100.0);
        this.checkPriority(100.0, "/foo/bar/zor");
        this.checkPriority(100.0, "/foo/bar");
        this.checkPriority(100.0, "/foo");
        this.checkPriority(100.0, "/");
        this.checkPriority(0.0, "/other/bar");
        this.checkPriority(0.0, "/other");
        this.checkPriority(100.0, "/foo/bar/zor/nested");
        this.checkPriority(100.0, "/foo/bar/zor/nested/deeper");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/foo/bar/zor/nested/big.zip");
    }

    @Test
    public void testSetOverlappingPaths() {
        this.setPriority("/shared/foo", 50.0);
        this.setPriority("/shared/bar", 100.0);
        this.tree.dump();
        this.checkPriority(50.0, "/shared/foo");
        this.checkPriority(100.0, "/shared/bar");
        this.checkPriority(100.0, "/");
        this.checkPriority(100.0, "/shared");
        this.checkPriority(0.0, "/other");
    }

    @Test
    public void testSetOverlappingPaths2() {
        this.setPriority("/shared/bar", 100.0);
        this.setPriority("/shared/foo", 50.0);
        this.checkPriority(50.0, "/shared/foo");
        this.checkPriority(100.0, "/shared/bar");
        this.checkPriority(100.0, "/");
        this.checkPriority(100.0, "/shared");
        this.checkPriority(0.0, "/other");
    }

    @Test
    public void testSetTreePriority() {
        this.setPriority("/promoted", 100.0);
        this.checkPriority(0.0, "/unrelated");
        this.checkPriority(100.0, "/promoted");
        this.checkPriority(100.0, "/promoted/sub");
        this.checkPriority(100.0, "/promoted/sub/sub");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/promoted/big.zip");
    }

    @Test
    public void testSetTreePriority2() {
        this.setPriority("/promoted/sub/sub", 50.0);
        this.checkPriority(50.0, "/promoted");
        this.checkPriority(50.0, "/promoted/sub");
        this.checkPriority(50.0, "/promoted/sub/sub");
        this.checkPriority(0.0, "/promoted/other");
        this.setPriority("/promoted", 100.0);
        this.checkPriority(0.0, "/unrelated");
        this.checkPriority(100.0, "/promoted");
        this.checkPriority(100.0, "/promoted/sub");
        this.checkPriority(100.0, "/promoted/sub/sub");
        this.checkPriority(100.0, "/promoted/other");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/promoted/sub/big.zip");
        this.checkPriority(Double.NEGATIVE_INFINITY, "/promoted/other/big.zip");
    }

    private void setPriority(String pathStr, double pri) {
        this.tree.setPriority(IPath.fromOSString((String)pathStr), pri);
    }

    private void checkPriority(double expected, String pathStr) {
        Assert.assertEquals((String)pathStr, (double)expected, (double)this.tree.priority((IResource)new MockResource(pathStr)), (double)0.0);
    }
}

