/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.tests;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchDialog;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchQuickAccessComputer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Test;

public class QuickAccessComputerTest {
    @Test
    public void testQuickAccessComputer() throws CoreException, IOException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.currentTimeMillis());
        project.create(null);
        project.open(null);
        IFile file = project.getFile("platform_tips.html");
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream contents = this.getClass().getResourceAsStream("platform_tips.html");){
            file.create(contents, true, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        QuickSearchDialogExtension dialog = new QuickSearchDialogExtension(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        String request = "Eclipse full screen mode";
        dialog.setInitialPattern(request);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Assert.assertTrue((boolean)DisplayHelper.waitForCondition((Display)dialog.getShell().getDisplay(), (long)2000L, () -> dialog.getResult().length > 0));
        dialog.close();
        Assert.assertEquals((long)1L, (long)new QuickSearchQuickAccessComputer().computeElements(request, (IProgressMonitor)new NullProgressMonitor()).length);
    }

    private final class QuickSearchDialogExtension
    extends QuickSearchDialog {
        private QuickSearchDialogExtension(IWorkbenchWindow window) {
            super(window);
        }

        public Object[] getResult() {
            this.computeResult();
            return super.getResult();
        }
    }
}

