/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.tests;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatcher;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatchers;
import org.eclipse.text.quicksearch.tests.MockResource;
import org.junit.Assert;
import org.junit.Test;

public class ResourceMatcherTest {
    @Test
    public void simpleRelativePattern() throws Exception {
        this.assertMatch(true, "*.java", "/myproject/something/nested/foo.java");
        this.assertMatch(false, "*.java", "/myproject/foo.class");
    }

    @Test
    public void commaSeparatedPaths() throws Exception {
        String[] patterns;
        String[] stringArray = patterns = new String[]{"*.java,*.properties", "*.java, *.properties", "*.java ,*.properties", "*.java , *.properties", " *.java  ,  *.properties ", " *.java  ,,  *.properties ", " *.java  ,  ,  *.properties ", " *.java  ,*.foo,  *.properties "};
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            this.assertMatch(true, pattern, "/myproject/something/nested/foo.java");
            this.assertMatch(true, pattern, "/myproject/something/nested/application.properties");
            this.assertMatch(false, pattern, "/myproject/something/nested/test.log");
            ++n2;
        }
    }

    @Test
    public void complexRelativePattern() throws Exception {
        this.assertMatch(true, "src/**/*.java", "/myproject/src/my/package/Foo.java");
        this.assertMatch(false, "src/**/*.java", "/myproject/resources/my/package/Foo.java");
    }

    @Test
    public void absolutePath() throws Exception {
        this.assertMatch(true, "/myproject/**/*.java", "/myproject/src/my/package/Foo.java");
        this.assertMatch(false, "/myproject/**/*.java", "/otherproject/src/my/package/Foo.java");
    }

    private void assertMatch(boolean expectedMatch, String patterns, String path) {
        Assert.assertTrue((boolean)IPath.fromOSString((String)path).isAbsolute());
        ResourceMatcher matcher = ResourceMatchers.commaSeparatedPaths((String)patterns);
        Assert.assertEquals((String)("Wrong match with pattern: '" + patterns + "'"), (Object)expectedMatch, (Object)matcher.matches((IResource)new MockResource(path)));
        Assert.assertNotNull((Object)matcher.toString());
    }
}

