/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.function.Function;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.ConvertLineDelimitersOperation;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.junit.Assert;
import org.junit.Test;

public class ConvertLineDelemiterTest {
    private static final String[] DELIMS = new String[]{"\r", "\n", "\r\n"};

    @Test
    public void testWithDelimnAtEnd() throws Exception {
        this.test(delim -> delim + "line1" + delim + "line2" + delim + delim + "line3" + delim);
    }

    @Test
    public void testWithoutDelimnAtEnd() throws Exception {
        this.test(delim -> "line1" + delim + "line2" + delim + delim + "line3");
    }

    void test(Function<String, String> testFile) throws Exception {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("ConvertLineDelemiterTest");
        p.create(null);
        p.open(null);
        try {
            String[] stringArray = DELIMS;
            int n = DELIMS.length;
            int n2 = 0;
            while (n2 < n) {
                String outputDelim = stringArray[n2];
                IFile[] files = new IFile[DELIMS.length];
                int i = 0;
                String[] stringArray2 = DELIMS;
                int n3 = DELIMS.length;
                int n4 = 0;
                while (n4 < n3) {
                    String inputDelim = stringArray2[n4];
                    String input = testFile.apply(inputDelim);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)("/ConvertLineDelemiterTest/test" + i + ".txt")));
                    Throwable throwable = null;
                    Object var16_22 = null;
                    try (ByteArrayInputStream s = new ByteArrayInputStream(input.getBytes());){
                        file.create((InputStream)s, true, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    files[i++] = file;
                    ++n4;
                }
                FileBufferOperationRunner runner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), null);
                ConvertLineDelimitersOperation op = new ConvertLineDelimitersOperation(outputDelim);
                runner.execute((IPath[])Arrays.stream(files).map(f -> f.getFullPath()).toArray(IPath[]::new), (IFileBufferOperation)op, null);
                IFile[] iFileArray = files;
                int n5 = files.length;
                int n6 = 0;
                while (n6 < n5) {
                    IFile file = iFileArray[n6];
                    String actual = Files.readString(file.getLocation().toFile().toPath());
                    String expected = testFile.apply(outputDelim);
                    Assert.assertEquals((Object)this.readable(expected), (Object)this.readable(actual));
                    ++n6;
                }
                iFileArray = files;
                n5 = files.length;
                n6 = 0;
                while (n6 < n5) {
                    IFile file = iFileArray[n6];
                    file.delete(true, null);
                    ++n6;
                }
                ++n2;
            }
        }
        finally {
            p.delete(true, null);
        }
    }

    private String readable(String s) {
        s = s.replace("\r", "\\r");
        s = s.replace("\n", "\\n");
        return s;
    }
}

