/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.FileBufferListener;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.osgi.framework.Bundle;

public abstract class FileBufferFunctions {
    private IProject fProject;
    protected ITextFileBufferManager fManager;
    private IPath fPath;
    @Rule
    public TestFailReporter failReporter = new TestFailReporter();

    protected abstract IPath createPath(IProject var1) throws Exception;

    protected abstract void setReadOnly(boolean var1) throws Exception;

    protected abstract boolean modifyUnderlyingFile() throws Exception;

    protected abstract boolean deleteUnderlyingFile() throws Exception;

    protected abstract IPath moveUnderlyingFile() throws Exception;

    protected abstract boolean isStateValidationSupported();

    protected abstract Class<IAnnotationModel> getAnnotationModelClass() throws Exception;

    @Before
    public void setUp() throws Exception {
        this.fManager = FileBuffers.getTextFileBufferManager();
        this.fProject = ResourceHelper.createProject("project");
        this.fPath = this.createPath(this.fProject);
        ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
        Assert.assertTrue((buffer == null ? 1 : 0) != 0);
    }

    protected IProject getProject() {
        return this.fProject;
    }

    @After
    public void tearDown() {
        ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
        Assert.assertTrue((buffer == null ? 1 : 0) != 0);
        ResourceHelper.deleteProject("project");
    }

    protected IPath getPath() {
        return this.fPath;
    }

    @Test
    public void test1() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertEquals((Object)this.fPath, (Object)buffer.getLocation());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test2() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.fPath);
            IFileInfo fileInfo = fileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            Assert.assertTrue(((lastModified = fileStore.fetchInfo().getLastModified()) == 0L || !fileBuffer.isSynchronized() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test3() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            Assert.assertTrue((boolean)fileBuffer.isDirty());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test4() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer1 = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertFalse((boolean)fileBuffer1.isShared());
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                ITextFileBuffer fileBuffer2 = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                Assert.assertTrue((boolean)fileBuffer1.isShared());
                Assert.assertTrue((boolean)fileBuffer2.isShared());
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
            Assert.assertFalse((boolean)fileBuffer1.isShared());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test5() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            long modificationStamp = fileBuffer.getModificationStamp();
            IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.fPath);
            IFileInfo fileInfo = fileStore.fetchInfo();
            Assert.assertEquals((Object)(modificationStamp != -1L ? 1 : 0), (Object)fileInfo.exists());
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            Assert.assertTrue(((lastModified = fileStore.fetchInfo().getLastModified()) == 0L || modificationStamp != fileBuffer.getModificationStamp() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test6() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            IDocument document = fileBuffer.getDocument();
            String originalContent = document.get();
            document.replace(document.getLength(), 0, "appendix");
            IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.fPath);
            IFileInfo fileInfo = fileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            fileBuffer.revert(null);
            Assert.assertEquals((Object)originalContent, (Object)document.get());
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test7() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            String originalContent = document.get();
            fileBuffer.commit(null, true);
            Assert.assertEquals((Object)originalContent, (Object)document.get());
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            fileBuffer.revert(null);
            Assert.assertEquals((Object)originalContent, (Object)document.get());
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                document = fileBuffer.getDocument();
                Assert.assertEquals((Object)originalContent, (Object)document.get());
                Assert.assertFalse((boolean)fileBuffer.isDirty());
                Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test8_1() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            Assert.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test8_2() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            Assert.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test9_1() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                Assert.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test9_2() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                Assert.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test10() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void bufferCreated(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }

            @Override
            public void bufferDisposed(IFileBuffer buf) {
                --this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            Assert.assertEquals((long)1L, (long)listener.count);
            Assert.assertNotNull((Object)listener.buffer);
            IFileBuffer fileBuffer = this.fManager.getFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            Assert.assertEquals((long)0L, (long)listener.count);
            Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
        }
        finally {
            try {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
            finally {
                this.fManager.removeFileBufferListener((IFileBufferListener)listener);
            }
        }
    }

    @Test
    public void test11_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;

            Listener() {
            }

            @Override
            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                Assert.assertEquals((long)1L, (long)listener.count);
                Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                Assert.assertTrue((boolean)listener.isDirty);
                fileBuffer.commit(null, true);
                Assert.assertEquals((long)2L, (long)listener.count);
                Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                Assert.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test11_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;

            Listener() {
            }

            @Override
            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                Assert.assertEquals((long)1L, (long)listener.count);
                Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                Assert.assertTrue((boolean)listener.isDirty);
                fileBuffer.revert(null);
                Assert.assertEquals((long)2L, (long)listener.count);
                Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                Assert.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test12_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;

            Listener() {
            }

            @Override
            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            @Override
            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                Assert.assertEquals((long)1L, (long)listener.preCount);
                Assert.assertSame((Object)fileBuffer, (Object)listener.preBuffer);
                Assert.assertEquals((long)1L, (long)listener.postCount);
                Assert.assertSame((Object)fileBuffer, (Object)listener.postBuffer);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test12_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;

            Listener() {
            }

            @Override
            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            @Override
            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.modifyUnderlyingFile()) {
                    Assert.assertEquals((long)1L, (long)listener.preCount);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.preBuffer);
                    Assert.assertEquals((long)1L, (long)listener.postCount);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.postBuffer);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    Assert.assertEquals((long)1L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                    Assert.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    Assert.assertEquals((long)1L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                    Assert.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    Assert.assertEquals((long)2L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                    Assert.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_4() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    Assert.assertEquals((long)2L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                    Assert.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test14() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void underlyingFileDeleted(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.deleteUnderlyingFile()) {
                    Assert.assertEquals((long)1L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test15() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public IPath newLocation;

            Listener() {
            }

            @Override
            public void underlyingFileMoved(IFileBuffer buf, IPath location) {
                ++this.count;
                this.buffer = buf;
                this.newLocation = location;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IPath newLocation = this.moveUnderlyingFile();
                if (!(newLocation == null || listener.count == 1 && listener.buffer == fileBuffer && newLocation.equals((Object)listener.newLocation))) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Wrong listener notifcation in ").append(this.getClass().getName()).append(":\n");
                    buf.append("listener.count: ").append(listener.count).append(" (expected: 1)\n");
                    if (newLocation.equals((Object)listener.newLocation)) {
                        buf.append("newLocation identical: true\n");
                    } else {
                        buf.append("listener.newLocation: ").append(listener.newLocation).append("\n");
                        buf.append("newLocation: ").append(newLocation).append("\n");
                    }
                    buf.append("buffers identical: ").append(listener.buffer == fileBuffer);
                    Assert.fail((String)buf.toString());
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test16_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.modifyUnderlyingFile()) {
                    Assert.assertSame((Object)listener.buffer, (Object)fileBuffer);
                    Assert.assertEquals((long)1L, (long)listener.count);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test16_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.deleteUnderlyingFile()) {
                    Assert.assertEquals((long)1L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test16_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                if (this.moveUnderlyingFile() != null) {
                    Assert.assertEquals((long)1L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test17_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    Assert.assertEquals((long)1L, (long)listener.count);
                    Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
                }
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test17_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                Assert.assertEquals((long)1L, (long)listener.count);
                Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test17_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
            try {
                fileBuffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.commit(null, true);
                Assert.assertEquals((long)1L, (long)listener.count);
                Assert.assertSame((Object)fileBuffer, (Object)listener.buffer);
            }
            finally {
                this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test18() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertNotNull((Object)buffer);
            Class<IAnnotationModel> clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                Assert.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void test19() throws Exception {
        class NotifiedListener
        extends FileBufferListener {
            int notifyCount = 0;

            NotifiedListener() {
            }

            @Override
            public void bufferCreated(IFileBuffer buffer) {
                ++this.notifyCount;
            }

            @Override
            public void bufferDisposed(IFileBuffer buffer) {
                ++this.notifyCount;
            }
        }
        NotifiedListener notifyCounter1 = new NotifiedListener();
        NotifiedListener notifyCounter2 = new NotifiedListener();
        FileBufferListener failingListener = new FileBufferListener(){

            @Override
            public void bufferCreated(IFileBuffer buffer) {
                class ForcedException
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    ForcedException() {
                    }

                    @Override
                    public void printStackTrace(PrintStream s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }

                    @Override
                    public void printStackTrace(PrintWriter s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }
                }
                throw new ForcedException();
            }

            @Override
            public void bufferDisposed(IFileBuffer buffer) {
                throw new ForcedException();
            }
        };
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter1);
        this.fManager.addFileBufferListener((IFileBufferListener)failingListener);
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter2);
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertNotNull((Object)buffer);
            Class<IAnnotationModel> clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                Assert.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter1);
            this.fManager.removeFileBufferListener((IFileBufferListener)failingListener);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter2);
        }
        Assert.assertEquals((long)2L, (long)notifyCounter1.notifyCount);
        Assert.assertEquals((long)2L, (long)notifyCounter2.notifyCount);
    }

    @Test
    public void testGetBufferForDocument() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertNotNull((Object)buffer);
            IDocument document = buffer.getDocument();
            Assert.assertNotNull((Object)document);
            Assert.assertSame((Object)buffer, (Object)this.fManager.getTextFileBuffer(document));
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    @Test
    public void testGetFileStoreAnnotationModel() throws Exception {
        IFileStore fileStore = EFS.getNullFileSystem().getStore(IPath.fromOSString((String)"/dev/null"));
        Assert.assertNotNull((Object)fileStore);
        this.fManager.connectFileStore(fileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(fileStore);
            IAnnotationModel model = fileBuffer.getAnnotationModel();
            Class<IAnnotationModel> clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                Assert.assertTrue((boolean)clazz.isInstance(model));
            } else {
                Assert.assertNotNull((Object)model);
            }
        }
        finally {
            this.fManager.disconnectFileStore(fileStore, null);
        }
    }

    @Test
    public void testGetFileBuffers() throws Exception {
        this.fManager.connect(this.fPath, LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.fPath, LocationKind.NORMALIZE);
            Assert.assertNotNull((Object)buffer);
            IFileBuffer[] fileBuffers = this.fManager.getFileBuffers();
            Assert.assertNotNull((Object)fileBuffers);
            Assert.assertEquals((long)1L, (long)fileBuffers.length);
            Assert.assertSame((Object)buffer, (Object)fileBuffers[0]);
            fileBuffers = this.fManager.getFileStoreFileBuffers();
            Assert.assertNotNull((Object)fileBuffers);
            Assert.assertEquals((long)0L, (long)fileBuffers.length);
        }
        finally {
            this.fManager.disconnect(this.fPath, LocationKind.NORMALIZE, null);
        }
    }

    public static class TestFailReporter
    extends TestWatcher {
        private static final String BUNDLE_ID = "org.eclipse.core.filebuffers.tests";
        ILog log = ILog.of((Bundle)Platform.getBundle((String)"org.eclipse.core.filebuffers.tests"));

        protected void failed(Throwable e, Description description) {
            Status status = new Status(4, BUNDLE_ID, "FAIL in " + String.valueOf(description), e);
            this.log.log((IStatus)status);
        }

        protected void succeeded(Description description) {
            Status status = new Status(1, BUNDLE_ID, "PASS in " + String.valueOf(description));
            this.log.log((IStatus)status);
        }
    }
}

