/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileBuffersTestPlugin;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;

public class FileBuffersForExternalFiles
extends FileBufferFunctions {
    @Override
    @After
    public void tearDown() {
        FileTool.delete(this.getPath());
        FileTool.delete(FileBuffers.getSystemFileAtLocation((IPath)this.getPath()).getParentFile());
        super.tearDown();
    }

    @Override
    protected IPath createPath(IProject project) throws Exception {
        File sourceFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), IPath.fromOSString((String)"testResources/ExternalFile"));
        File externalFile = FileTool.createTempFileInPlugin(FileBuffersTestPlugin.getDefault(), IPath.fromOSString((String)"externalResources/ExternalFile"));
        FileTool.copy(sourceFile, externalFile);
        return IPath.fromOSString((String)externalFile.getAbsolutePath());
    }

    @Override
    protected void setReadOnly(boolean state) throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        Assert.assertNotNull((Object)fileStore);
        fileStore.fetchInfo().setAttribute(2, state);
    }

    @Override
    protected boolean isStateValidationSupported() {
        return false;
    }

    @Override
    protected boolean deleteUnderlyingFile() throws Exception {
        return false;
    }

    @Override
    protected IPath moveUnderlyingFile() throws Exception {
        return null;
    }

    @Override
    protected boolean modifyUnderlyingFile() throws Exception {
        return false;
    }

    @Override
    protected Class<IAnnotationModel> getAnnotationModelClass() throws Exception {
        return null;
    }
}

