/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileBuffersTestPlugin;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class FileBuffersForFilesInLinkedFolders
extends FileBufferFunctions {
    private File fExternalFile;

    @Override
    @After
    public void tearDown() {
        FileTool.delete(this.getPath());
        File file = this.fExternalFile;
        FileTool.delete(file);
        file = file.getParentFile();
        FileTool.delete(file);
        file = file.getParentFile();
        FileTool.delete(file);
        super.tearDown();
    }

    @Override
    protected IPath createPath(IProject project) throws Exception {
        File sourceFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), IPath.fromOSString((String)"testResources/linkedFolderTarget/FileInLinkedFolder"));
        this.fExternalFile = FileTool.createTempFileInPlugin(FileBuffersTestPlugin.getDefault(), IPath.fromOSString((String)"externalResources/linkedFolderTarget/FileInLinkedFolder"));
        FileTool.copy(sourceFile, this.fExternalFile);
        IFolder folder = ResourceHelper.createLinkedFolder((IContainer)project, IPath.fromOSString((String)"LinkedFolder"), this.fExternalFile.getParentFile());
        IFile file = folder.getFile(IPath.fromOSString((String)"FileInLinkedFolder"));
        return file.getFullPath();
    }

    @Override
    protected void setReadOnly(boolean state) throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(state);
        file.setResourceAttributes(attributes);
    }

    @Override
    protected boolean isStateValidationSupported() {
        return true;
    }

    @Override
    protected boolean deleteUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        file.delete(true, false, null);
        return file.exists();
    }

    @Override
    protected IPath moveUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceHelper.createFolder("project/folderA");
        IPath path = IPath.fromOSString((String)"/project/folderA/MovedLinkedFile");
        file.move(path, true, false, null);
        file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (file != null && file.exists()) {
            return path;
        }
        return null;
    }

    @Override
    protected boolean modifyUnderlyingFile() throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        Assert.assertTrue((boolean)fileStore.fetchInfo().exists());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStream out = fileStore.openOutputStream(0, null);){
                out.write("Changed content of file in linked folder".getBytes());
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException x) {
            Assert.fail();
        }
        IFileInfo fileInfo = fileStore.fetchInfo();
        fileInfo.setLastModified(1000L);
        fileStore.putInfo(fileInfo, 2048, null);
        IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        iFile.refreshLocal(2, null);
        return true;
    }

    @Override
    protected Class<IAnnotationModel> getAnnotationModelClass() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.editors");
        return bundle != null ? IAnnotationModel.class : null;
    }
}

