/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class FileTool {
    private static final int MAX_RETRY = 5;
    private static byte[] buffer = new byte[8192];

    /*
     * Exception decompiling
     */
    public static void unzip(ZipFile zipFile, File dstDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void transferData(File source, File destination) throws IOException {
        destination.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream is = new FileInputStream(source);
            try {
                try (FileOutputStream os = new FileOutputStream(destination);){
                    FileTool.transferData(is, os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void transferData(InputStream source, OutputStream destination) throws IOException {
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = source.read(buffer, 0, buffer.length);
            if (bytesRead == -1) continue;
            destination.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            String[] srcChildren = src.list();
            if (srcChildren == null) {
                throw new IOException("Content from directory '" + src.getAbsolutePath() + "' can not be listed.");
            }
            String[] stringArray = srcChildren;
            int n = srcChildren.length;
            int n2 = 0;
            while (n2 < n) {
                String srcChild2 = stringArray[n2];
                File srcChild = new File(src, srcChild2);
                File dstChild = new File(dst, srcChild2);
                FileTool.copy(srcChild, dstChild);
                ++n2;
            }
        } else {
            FileTool.transferData(src, dst);
        }
    }

    public static File getFileInPlugin(Plugin plugin, IPath path) {
        try {
            URL installURL = plugin.getBundle().getEntry(path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File createTempFileInPlugin(Plugin plugin, IPath path) {
        IPath stateLocation = plugin.getStateLocation();
        stateLocation = stateLocation.append(path);
        return stateLocation.toFile();
    }

    public static void write(String fileName, String content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(fileName);){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void delete(IPath path) {
        File file = FileBuffers.getSystemFileAtLocation((IPath)path);
        FileTool.delete(file);
    }

    public static void delete(File file) {
        if (file.exists()) {
            int i = 0;
            while (i < 5) {
                if (file.delete()) {
                    i = 5;
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }
}

