/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;
import org.eclipse.jdt.core.tests.performance.NullPrintWriter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.SourceElementRequestorAdapter;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalToken;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FullSourceWorkspaceBuildTests
extends FullSourceWorkspaceTests {
    private static int TESTS_COUNT = 0;
    private static final int ITERATIONS_COUNT = 10;
    private static final int WARMUP_COUNT = 3;
    private static final int SCAN_REPEAT = 800;
    private static final int TIME_THRESHOLD = 150;
    private static PrintStream[] LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    private static final String ALL_OPTIONS = "-warn:allDeprecation,allJavadoc,assertIdentifier,charConcat,conditionAssign,constructorName,deprecation,emptyBlock,fieldHiding,finally,indirectStatic,intfNonInherited,localHiding,maskedCatchBlock,nls,noEffectAssign,pkgDefaultMethod,semicolon,unqualifiedField,unusedArgument,unusedImport,unusedLocal,unusedPrivate,unusedThrown,unnecessaryElse,uselessTypeCheck,specialParamHiding,staticReceiver,syntheticAccess,tasks(TODO|FIX|XXX)";
    static final String[] JDT_CORE_SRC_PATHS = new String[]{"batch", "codeassist", "compiler", "dom", "eval", "formatter", "model", "search"};
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken;

    public FullSourceWorkspaceBuildTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceBuildTests.buildSuite(FullSourceWorkspaceBuildTests.testClass());
        TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceBuildTests.createPrintStream(FullSourceWorkspaceBuildTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceBuildTests.class;
    }

    void build(final IJavaProject javaProject, Hashtable options, boolean noWarning) throws IOException, CoreException {
        if (DEBUG) {
            System.out.print("\tstart build...");
        }
        JavaCore.setOptions((Hashtable)options);
        if (PRINT) {
            System.out.println("JavaCore options: " + String.valueOf(options));
        }
        if (javaProject == null) {
            this.runGc();
            this.startMeasuring();
            ENV.fullBuild();
            this.stopMeasuring();
        } else {
            if (PRINT) {
                System.out.println("Project options: " + String.valueOf(javaProject.getOptions(false)));
            }
            int i = 0;
            while (i < 3) {
                ENV.fullBuild(javaProject.getProject().getName());
                ++i;
            }
            int max = MEASURES_COUNT;
            int i2 = 0;
            while (i2 < max) {
                this.runGc();
                this.startMeasuring();
                IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ENV.fullBuild(javaProject.getPath());
                    }
                };
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                workspace.run(compilation, null, 1, null);
                this.stopMeasuring();
                ++i2;
            }
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IMarker[] markers = workspaceRoot.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        ArrayList<String> resources = new ArrayList<String>();
        ArrayList<Object> messages = new ArrayList<Object>();
        int warnings = 0;
        int i = 0;
        int length = markers.length;
        while (i < length) {
            IMarker marker = markers[i];
            switch ((Integer)marker.getAttribute("severity")) {
                case 2: {
                    resources.add(marker.getResource().getName());
                    messages.add(marker.getAttribute("message"));
                    break;
                }
                case 1: {
                    ++warnings;
                    if (!noWarning) break;
                    resources.add(marker.getResource().getName());
                    messages.add(marker.getAttribute("message"));
                }
            }
            ++i;
        }
        workspaceRoot.deleteMarkers("org.eclipse.jdt.core.problem", true, 2);
        int size = messages.size();
        if (size > 0) {
            StringBuilder debugBuffer = new StringBuilder();
            int i3 = 0;
            while (i3 < size) {
                debugBuffer.append(resources.get(i3));
                debugBuffer.append(":\n\t");
                debugBuffer.append(messages.get(i3));
                debugBuffer.append('\n');
                ++i3;
            }
            System.out.println(this.scenarioShortName + ": Unexpected ERROR marker(s):\n" + debugBuffer.toString());
            System.out.println("--------------------");
            String target = javaProject == null ? "workspace" : javaProject.getElementName();
            FullSourceWorkspaceBuildTests.assertEquals((String)("Found " + size + " unexpected errors while building " + target), (int)0, (int)size);
        }
        if (DEBUG) {
            System.out.println("done");
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (warnings > 0) {
            System.out.println("\t- " + warnings + " warnings found while performing build.");
        }
        if (this.scenarioComment == null) {
            this.scenarioComment = new StringBuilder("[" + TEST_POSITION + "]");
        } else {
            this.scenarioComment.append(' ');
        }
        this.scenarioComment.append("warn=");
        this.scenarioComment.append(warnings);
    }

    void compile(String pluginID, String options, boolean log, String[] srcPaths) throws IOException, CoreException {
        this.compile(pluginID, options, null, log, srcPaths);
    }

    void compile(String pluginID, String options, String compliance, boolean log, String[] srcPaths) throws IOException, CoreException {
        Object sources;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String targetWorkspacePath = workspaceRoot.getProject(pluginID).getLocation().toFile().toPath().normalize().toAbsolutePath().toString();
        String logFileName = targetWorkspacePath + File.separator + this.getName() + ".log";
        String workspacePath = workspaceRoot.getLocation().toFile().toPath().normalize().toAbsolutePath().toString() + File.separator;
        String binPath = File.separator + "bin" + File.pathSeparator;
        String classpath = " -cp " + workspacePath + "org.eclipse.osgi" + binPath + workspacePath + "org.eclipse.jface" + binPath + workspacePath + "org.eclipse.core.runtime" + binPath + workspacePath + "org.eclipse.core.resources" + binPath + workspacePath + "org.eclipse.text" + binPath;
        Object object = sources = srcPaths == null ? " " + targetWorkspacePath : "";
        if (srcPaths != null) {
            int i = 0;
            int l = srcPaths.length;
            while (i < l) {
                String path = workspacePath + pluginID + File.separator + srcPaths[i];
                if (path.indexOf(" ") > 0) {
                    path = "\"" + path + "\"";
                }
                sources = (String)sources + " " + path;
                ++i;
            }
        }
        this.compile((String)sources, options, classpath, null, log, logFileName);
    }

    void compile(String srcPath, long fileSize, String options, String compliance, boolean log) throws IOException {
        String targetWorkspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().toPath().normalize().toAbsolutePath().toString();
        String logFileName = targetWorkspacePath + File.separator + this.getName() + ".log";
        File file = FullSourceWorkspaceBuildTests.fetchFromBinariesProject(srcPath, fileSize);
        Object path = file.getAbsolutePath();
        if (((String)path).indexOf(" ") > 0) {
            path = "\"" + (String)path + "\"";
        }
        String sources = " " + (String)path;
        this.compile(sources, options, "", compliance, log, logFileName);
    }

    private void compile(String sources, String options, String classpath, String compliance, boolean log, String logFileName) {
        compliance = compliance == null ? " -" + (COMPLIANCE == null ? "1.4" : COMPLIANCE) : " -" + (String)compliance;
        String cmdLine = classpath + (String)compliance + " -g -preserveAllLocals " + (options == null ? "" : options) + " -d " + COMPILER_OUTPUT_DIR + (String)(log ? " -log " + logFileName : "") + sources;
        if (PRINT) {
            System.out.println("\tCompiler command line = " + cmdLine);
        }
        int warnings = 0;
        StringWriter errStrWriter = new StringWriter();
        PrintWriter err = new PrintWriter(errStrWriter);
        PrintWriter out = new PrintWriter(new StringWriter());
        Main warmup = new Main(out, err, false, null, null);
        int i = 1;
        while (i < 3) {
            warmup.compile(Main.tokenize((String)cmdLine));
            ++i;
        }
        if (warmup.globalErrorsCount > 0) {
            System.out.println(this.scenarioShortName + ": " + warmup.globalErrorsCount + " Unexpected compile ERROR!");
            if (DEBUG) {
                System.out.println(errStrWriter.toString());
                System.out.println("--------------------");
            }
        }
        if (!"none".equals(COMPILER_OUTPUT_DIR)) {
            org.eclipse.jdt.core.tests.util.Util.delete((String)COMPILER_OUTPUT_DIR);
        }
        warnings = warmup.globalWarningsCount;
        if (!log) {
            org.eclipse.jdt.core.tests.util.Util.writeToFile((String)errStrWriter.toString(), (String)logFileName);
        }
        err = null;
        out = null;
        errStrWriter = null;
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            NullPrintWriter nullPrint = new NullPrintWriter();
            Main main = new Main((PrintWriter)nullPrint, (PrintWriter)nullPrint, false, null, null);
            this.startMeasuring();
            main.compile(Main.tokenize((String)cmdLine));
            this.stopMeasuring();
            if (!"none".equals(COMPILER_OUTPUT_DIR)) {
                org.eclipse.jdt.core.tests.util.Util.delete((String)COMPILER_OUTPUT_DIR);
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (warnings > 0) {
            System.out.println("\t- " + warnings + " warnings found while performing batch compilation.");
        }
        if (this.scenarioComment == null) {
            this.scenarioComment = new StringBuilder("[" + TEST_POSITION + "]");
        } else {
            this.scenarioComment.append(' ');
        }
        this.scenarioComment.append("warn=");
        this.scenarioComment.append(warnings);
    }

    long[] parseFile(String fileName, int kind, int iterations) throws InvalidInputException, IOException {
        File file = new File(fileName);
        char[] content = Util.getFileCharContent((File)file, null);
        CompilerOptions options = new CompilerOptions();
        options.sourceLevel = CompilerOptions.getFirstSupportedJdkLevel();
        options.targetJDK = CompilerOptions.getFirstSupportedJdkLevel();
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitAfterAllProblems(), options, (IProblemFactory)new DefaultProblemFactory());
        Parser parser = null;
        switch (kind) {
            case 1: {
                parser = new SourceElementParser((ISourceElementRequestor)new SourceElementRequestorAdapter(), problemReporter.problemFactory, options, true, true);
                break;
            }
            default: {
                parser = new Parser(problemReporter, true);
            }
        }
        int i = 0;
        while (i < 2) {
            CompilationUnit unit = new CompilationUnit(content, file.getName(), null);
            CompilationResult unitResult = new CompilationResult((ICompilationUnit)unit, 0, 1, options.maxProblemsPerUnit);
            CompilationUnitDeclaration unitDeclaration = parser.dietParse((ICompilationUnit)unit, unitResult);
            parser.getMethodBodies(unitDeclaration);
            ++i;
        }
        this.runGc();
        long parsedLines = 0L;
        long parsedCharacters = 0L;
        long startNanos = System.nanoTime();
        this.startMeasuring();
        int i2 = 0;
        while (i2 < iterations) {
            CompilationUnit unit = new CompilationUnit(content, file.getName(), null);
            CompilationResult unitResult = new CompilationResult((ICompilationUnit)unit, 0, 1, options.maxProblemsPerUnit);
            CompilationUnitDeclaration unitDeclaration = parser.dietParse((ICompilationUnit)unit, unitResult);
            parser.getMethodBodies(unitDeclaration);
            parsedCharacters += (long)content.length;
            parsedLines += (long)unitResult.getLineSeparatorPositions().length;
            ++i2;
        }
        this.stopMeasuring();
        if (DEBUG) {
            long timeMs = (System.nanoTime() - startNanos) / 1000000L;
            if (timeMs < 150L) {
                System.err.println(parsedLines + " lines/" + parsedCharacters + " characters parsed");
            } else {
                System.out.println(parsedLines + " lines/" + parsedCharacters + " characters parsed");
            }
        }
        return new long[]{parsedCharacters, parsedLines};
    }

    void parseParserFile(final int kind) throws InvalidInputException, IOException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final String workspacePath = workspaceRoot.getLocation().toFile().toPath().normalize().toAbsolutePath().toString();
        int i = 0;
        while (i < MEASURES_COUNT) {
            IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        FullSourceWorkspaceBuildTests.this.parseFile(workspacePath + String.valueOf(PARSER_WORKING_COPY.getPath()), kind, 60);
                    }
                    catch (InvalidInputException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            if (workspace.isTreeLocked()) {
                compilation.run(null);
            } else {
                workspace.run(compilation, null, 1, null);
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    /*
     * Unable to fully structure code
     */
    void scanFile(String fileName, int kind) throws InvalidInputException, IOException {
        tokenCount = 0L;
        content = Util.getFileCharContent((File)new File(fileName), null);
        scanner = new Scanner();
        scanner.setSource(content);
        i = 0;
        while (i < 2) {
            scanner.resetTo(0, content.length);
            block27: while (true) {
                token = scanner.getNextToken();
                switch (kind) {
                    case 0: {
                        switch (FullSourceWorkspaceBuildTests.$SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken()[token.ordinal()]) {
                            case 145: {
                                break block27;
                            }
                        }
                        continue block27;
                    }
                    case 1: {
                        switch (FullSourceWorkspaceBuildTests.$SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken()[token.ordinal()]) {
                            case 145: {
                                break block27;
                            }
                            case 9: {
                                scanner.getCurrentIdentifierSource();
                            }
                        }
                    }
                    default: {
                        continue block27;
                    }
                }
                break;
            }
            ++i;
        }
        size = 0L;
        i = 0;
        while (i < FullSourceWorkspaceBuildTests.MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            j = 0;
            while (j < 800) {
                scanner.resetTo(0, content.length);
                block30: while (true) {
                    token = scanner.getNextToken();
                    switch (kind) {
                        case 0: {
                            switch (FullSourceWorkspaceBuildTests.$SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken()[token.ordinal()]) {
                                case 145: {
                                    break block30;
                                }
                            }
                            ** GOTO lbl50
                        }
                        case 1: {
                            switch (FullSourceWorkspaceBuildTests.$SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken()[token.ordinal()]) {
                                case 145: {
                                    break block30;
                                }
                                case 9: {
                                    c = scanner.getCurrentIdentifierSource();
                                    size += (long)c.length;
                                }
                            }
                        }
lbl50:
                        // 4 sources

                        default: {
                            ++tokenCount;
                            continue block30;
                        }
                    }
                    break;
                }
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (FullSourceWorkspaceBuildTests.DEBUG) {
            switch (kind) {
                case 0: {
                    System.out.println(tokenCount + " tokens read.");
                    break;
                }
                case 1: {
                    System.out.print(tokenCount + " tokens were read (" + size + " characters)");
                }
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        super.tearDown();
    }

    public void testScanner() throws InvalidInputException, IOException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final String workspacePath = workspaceRoot.getLocation().toFile().toPath().normalize().toAbsolutePath().toString();
        IWorkspaceRunnable compilation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    FullSourceWorkspaceBuildTests.this.scanFile(workspacePath + String.valueOf(PARSER_WORKING_COPY.getPath()), 1);
                }
                catch (InvalidInputException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        if (workspace.isTreeLocked()) {
            compilation.run(null);
        } else {
            workspace.run(compilation, null, 1, null);
        }
    }

    public void testParser() throws InvalidInputException, IOException, CoreException {
        this.parseParserFile(0);
    }

    public void _testSourceParser() throws InvalidInputException, IOException, CoreException {
        this.parseParserFile(1);
    }

    public void testFullBuildDefault() throws CoreException, IOException {
        this.tagAsSummary("Build entire workspace", false);
        this.build(null, this.warningOptions(0), false);
    }

    public void testFullBuildProjectNoWarning() throws CoreException, IOException {
        this.tagAsSummary("Build JDT/Core project (no warning)", false);
        this.build(JDT_CORE_PROJECT, this.warningOptions(-1), true);
    }

    public void testFullBuildProjectDefault() throws CoreException, IOException {
        this.tagAsGlobalSummary("Build JDT/Core project", true);
        this.build(JDT_CORE_PROJECT, this.warningOptions(0), false);
    }

    public void testFullBuildProjectAllWarnings() throws CoreException, IOException {
        this.tagAsSummary("Build JDT/Core project (all warnings)", false);
        this.build(JDT_CORE_PROJECT, this.warningOptions(1), false);
    }

    public void testBatchCompilerNoWarning() throws IOException, CoreException {
        this.tagAsSummary("Compile folders using cmd line (no warn)", false);
        this.compile("org.eclipse.jdt.core", "-nowarn", null, true, null);
    }

    public void testCompileJDTCoreProjectNoWarning() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with cmd line (no warn)", false);
        this.compile("org.eclipse.jdt.core", "-nowarn", null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileJDTCoreProjectDefault() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with command line", true);
        this.compile("org.eclipse.jdt.core", "", null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileJDTCoreProjectJavadoc() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with cmd line (javadoc)", false);
        this.compile("org.eclipse.jdt.core", "-warn:javadoc", null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileJDTCoreProjectAllWarnings() throws IOException, CoreException {
        this.tagAsSummary("Compile JDT/Core with cmd line (all)", false);
        this.compile("org.eclipse.jdt.core", ALL_OPTIONS, null, false, JDT_CORE_SRC_PATHS);
    }

    public void testCompileSWTProjectDefault() throws IOException, CoreException {
        this.tagAsSummary("Compile SWT with command line", false);
        String[] sourcePaths = new String[]{"Eclipse SWT/win32", "Eclipse SWT/common", "Eclipse SWT/common_j2se", "Eclipse SWT PI/win32", "Eclipse SWT PI/common_j2se", "Eclipse SWT OLE Win32/win32", "Eclipse SWT Accessibility/win32", "Eclipse SWT Accessibility/common", "Eclipse SWT AWT/win32", "Eclipse SWT AWT/common", "Eclipse SWT Drag and Drop/win32", "Eclipse SWT Drag and Drop/common", "Eclipse SWT Printing/win32", "Eclipse SWT Printing/common", "Eclipse SWT Program/win32", "Eclipse SWT Program/common", "Eclipse SWT Custom Widgets/common", "Eclipse SWT Browser/common", "Eclipse SWT Browser/win32"};
        this.compile("org.eclipse.swt", "", null, false, sourcePaths);
    }

    public void testBuildGenericType() throws IOException, CoreException {
        this.tagAsSummary("Build Generic Type ", false);
        this.compile("EclipseVisitorBug.java", 37884L, "", "1.6", false);
    }

    public void testBug434326() throws IOException, CoreException {
        this.tagAsSummary("Build with Generic Types ", false);
        this.compile("GenericsTest.java", 12629541L, "", "1.8", false);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken() {
        if ($SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken != null) {
            return $SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken;
        }
        int[] nArray = new int[TerminalToken.values().length];
        try {
            nArray[TerminalToken.TokenNameAND.ordinal()] = 108;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameAND_AND.ordinal()] = 102;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameAND_EQUAL.ordinal()] = 94;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameARROW.ordinal()] = 129;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameAT.ordinal()] = 127;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameAT308.ordinal()] = 135;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameAT308DOTDOTDOT.ordinal()] = 136;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameBeginCasePattern.ordinal()] = 142;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameBeginIntersectionCast.ordinal()] = 132;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameBeginLambda.ordinal()] = 131;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameBeginTypeArguments.ordinal()] = 133;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOLON.ordinal()] = 123;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOLON_COLON.ordinal()] = 130;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOMMA.ordinal()] = 124;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOMMENT_BLOCK.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOMMENT_JAVADOC.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOMMENT_LINE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCOMMENT_MARKDOWN.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCaseArrow.ordinal()] = 137;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameCharacterLiteral.ordinal()] = 78;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameDIVIDE.ordinal()] = 112;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameDIVIDE_EQUAL.ordinal()] = 93;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameDOT.ordinal()] = 125;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameDoubleLiteral.ordinal()] = 77;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameELLIPSIS.ordinal()] = 128;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameEOF.ordinal()] = 145;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameEQUAL.ordinal()] = 126;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameEQUAL_EQUAL.ordinal()] = 83;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameERROR.ordinal()] = 146;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameElidedSemicolonAndRightBrace.ordinal()] = 134;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameFloatingPointLiteral.ordinal()] = 76;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameGREATER.ordinal()] = 113;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameGREATER_EQUAL.ordinal()] = 85;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameIdentifier.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameIntegerLiteral.ordinal()] = 74;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameInvalid.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLBRACE.ordinal()] = 117;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLBRACKET.ordinal()] = 119;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLEFT_SHIFT.ordinal()] = 87;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLEFT_SHIFT_EQUAL.ordinal()] = 98;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLESS.ordinal()] = 114;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLESS_EQUAL.ordinal()] = 84;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLPAREN.ordinal()] = 115;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameLongLiteral.ordinal()] = 75;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameMINUS.ordinal()] = 104;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameMINUS_EQUAL.ordinal()] = 91;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameMINUS_MINUS.ordinal()] = 82;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameMULTIPLY.ordinal()] = 109;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameMULTIPLY_EQUAL.ordinal()] = 92;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameNOT.ordinal()] = 105;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameNOT_EQUAL.ordinal()] = 86;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameNotAToken.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameOR.ordinal()] = 110;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameOR_EQUAL.ordinal()] = 95;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameOR_OR.ordinal()] = 101;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamePLUS.ordinal()] = 103;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamePLUS_EQUAL.ordinal()] = 90;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamePLUS_PLUS.ordinal()] = 81;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameQUESTION.ordinal()] = 122;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRBRACE.ordinal()] = 118;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRBRACKET.ordinal()] = 120;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameREMAINDER.ordinal()] = 106;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameREMAINDER_EQUAL.ordinal()] = 97;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRIGHT_SHIFT.ordinal()] = 88;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRIGHT_SHIFT_EQUAL.ordinal()] = 99;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRPAREN.ordinal()] = 116;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRestrictedIdentifierWhen.ordinal()] = 143;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRestrictedIdentifierYield.ordinal()] = 138;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRestrictedIdentifierpermits.ordinal()] = 141;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRestrictedIdentifierrecord.ordinal()] = 139;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameRestrictedIdentifiersealed.ordinal()] = 140;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameSEMICOLON.ordinal()] = 121;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameSingleQuoteStringLiteral.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameStringLiteral.ordinal()] = 79;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameTWIDDLE.ordinal()] = 111;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameTextBlock.ordinal()] = 80;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameUNDERSCORE.ordinal()] = 144;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT.ordinal()] = 89;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL.ordinal()] = 100;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameWHITESPACE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameXOR.ordinal()] = 107;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameXOR_EQUAL.ordinal()] = 96;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameabstract.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameassert.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameboolean.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamebreak.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamebyte.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamecase.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamecatch.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamechar.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameclass.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameconst.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamecontinue.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamedefault.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamedo.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamedouble.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameelse.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameenum.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameexports.ordinal()] = 68;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameextends.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamefalse.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamefinal.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamefinally.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamefloat.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamefor.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamegoto.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameif.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameimplements.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameimport.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameinstanceof.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameint.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameinterface.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamelong.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamemodule.ordinal()] = 64;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamenative.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamenew.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamenon_sealed.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamenull.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameopen.ordinal()] = 65;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameopens.ordinal()] = 69;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamepackage.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameprivate.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameprotected.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameprovides.ordinal()] = 72;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamepublic.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamerequires.ordinal()] = 66;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamereturn.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameshort.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamestatic.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamestrictfp.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamesuper.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameswitch.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamesynchronized.ordinal()] = 54;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamethis.ordinal()] = 55;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamethrow.ordinal()] = 56;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamethrows.ordinal()] = 57;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameto.ordinal()] = 70;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNametransient.ordinal()] = 58;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNametransitive.ordinal()] = 67;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNametrue.ordinal()] = 59;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNametry.ordinal()] = 60;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNameuses.ordinal()] = 71;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamevoid.ordinal()] = 61;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamevolatile.ordinal()] = 62;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamewhile.ordinal()] = 63;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[TerminalToken.TokenNamewith.ordinal()] = 73;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jdt$internal$compiler$parser$TerminalToken = nArray;
        return nArray;
    }
}

