/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.PrintStream;
import java.text.NumberFormat;
import junit.framework.Test;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;

public class FullSourceWorkspaceCompletionTests
extends FullSourceWorkspaceTests {
    private static final int WARMUP_COUNT = 10;
    private static final int ITERATION_COUNT = 40;
    static int[] PROPOSAL_COUNTS;
    static int TESTS_COUNT;
    static int TESTS_LENGTH;
    static int COMPLETIONS_COUNT;
    private static PrintStream[] LOG_STREAMS;

    static {
        TESTS_COUNT = 0;
        COMPLETIONS_COUNT = 0;
        LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    }

    public FullSourceWorkspaceCompletionTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceCompletionTests.buildSuite(FullSourceWorkspaceCompletionTests.testClass());
        TESTS_LENGTH = TESTS_COUNT = suite.countTestCases();
        PROPOSAL_COUNTS = new int[TESTS_COUNT];
        FullSourceWorkspaceCompletionTests.createPrintStream(FullSourceWorkspaceCompletionTests.testClass(), LOG_STREAMS, TESTS_COUNT, "Complete");
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceCompletionTests.class;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        COMPLETIONS_COUNT = 0;
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        if (TESTS_COUNT == 0) {
            System.out.println("-------------------------------------");
            System.out.println("Completion performance test statistics:");
            NumberFormat intFormat = NumberFormat.getIntegerInstance();
            System.out.println("  - " + intFormat.format(COMPLETIONS_COUNT) + " completions have been performed");
            System.out.println("  - following proposals have been done:");
            int i = 0;
            while (i < TESTS_LENGTH) {
                System.out.println("  \t+ test " + i + ": " + intFormat.format(PROPOSAL_COUNTS[i]) + " proposals");
                ++i;
            }
            System.out.println("-------------------------------------\n");
        }
        super.tearDown();
    }

    private void complete(String projectName, String packageName, String unitName, String completeAt, String completeBehind, int warmupCount, int iterationCount) throws JavaModelException {
        this.complete(projectName, packageName, unitName, completeAt, completeBehind, null, warmupCount, iterationCount);
    }

    private void complete(String projectName, String packageName, String unitName, String completeAt, String completeBehind, int[] ignoredKinds, int warmupCount, int iterationCount) throws JavaModelException {
        int i;
        this.waitUntilIndexesReady();
        TestCompletionRequestor requestor = new TestCompletionRequestor();
        if (ignoredKinds != null) {
            int i2 = 0;
            while (i2 < ignoredKinds.length) {
                requestor.setIgnored(ignoredKinds[i2], true);
                ++i2;
            }
        }
        ICompilationUnit unit = this.getCompilationUnit(projectName, packageName, unitName);
        String str = unit.getSource();
        int completionIndex = str.indexOf(completeAt) + completeBehind.length();
        if (DEBUG) {
            System.out.print("Perform code assist inside " + unitName + "...");
        }
        if (warmupCount > 0) {
            unit.codeComplete(completionIndex, (CompletionRequestor)requestor);
            i = 1;
            while (i < warmupCount) {
                unit.codeComplete(completionIndex, (CompletionRequestor)requestor);
                ++i;
            }
        }
        this.runGc();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.startMeasuring();
            int j = 0;
            while (j < iterationCount) {
                unit.codeComplete(completionIndex, (CompletionRequestor)requestor);
                ++COMPLETIONS_COUNT;
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        if (DEBUG) {
            System.out.println("done!");
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPerfCompleteMethodDeclaration() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "IType {", "IType {", 10, 40);
    }

    public void testPerfCompleteMemberAccess() throws JavaModelException {
        this.tagAsGlobalSummary("Codeassist in expression", true);
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "this.", "this.", null, 10, 40);
    }

    public void testPerfCompleteTypeReference() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "ArrayList list", "A", 10, 40);
    }

    public void testPerfCompleteEmptyName() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "", 10, 40);
    }

    public void testPerfCompleteName() throws JavaModelException {
        this.tagAsSummary("Codeassist in name", true);
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "p", null, 10, 40);
    }

    public void testPerfCompleteEmptyNameWithoutTypes() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "", new int[]{9}, 10, 40);
    }

    public void testPerfCompleteNameWithoutTypes() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "p", new int[]{9}, 10, 40);
    }

    public void testPerfCompleteEmptyNameWithoutMethods() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "", new int[]{6}, 10, 40);
    }

    public void testPerfCompleteNameWithoutMethods() throws JavaModelException {
        this.complete("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core", "SourceType.java", "params.add", "p", new int[]{6}, 10, 40);
    }

    class TestCompletionRequestor
    extends CompletionRequestor {
        TestCompletionRequestor() {
        }

        public void accept(CompletionProposal proposal) {
            int n = TESTS_LENGTH - TESTS_COUNT;
            PROPOSAL_COUNTS[n] = PROPOSAL_COUNTS[n] + 1;
        }
    }
}

