/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.PrintStream;
import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;

public class FullSourceWorkspaceFormatterTests
extends FullSourceWorkspaceTests {
    static int TESTS_COUNT = 0;
    private static final int WARMUP_COUNT = 5;
    static int TESTS_LENGTH;
    private static PrintStream[] LOG_STREAMS;
    static IPath FORMAT_TYPE_PATH;
    static String FORMAT_TYPE_SOURCE;

    static {
        LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    }

    public FullSourceWorkspaceFormatterTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceFormatterTests.buildSuite(FullSourceWorkspaceFormatterTests.testClass());
        TESTS_LENGTH = TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceFormatterTests.createPrintStream(FullSourceWorkspaceFormatterTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceFormatterTests.class;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        System.out.print("\t- Read big file source...");
        File file = FullSourceWorkspaceFormatterTests.fetchFromBinariesProject("GenericTypeTest.java", 1258374L);
        String sourceFilePath = file.getAbsolutePath();
        long startNanos = System.nanoTime();
        FORMAT_TYPE_SOURCE = Util.fileContent((String)sourceFilePath);
        System.out.println("(" + (System.nanoTime() - startNanos) / 1000000L + "ms)");
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        super.tearDown();
    }

    public void testFormatDefault() throws JavaModelException {
        this.tagAsSummary("Format file with default options", false);
        String source = PARSER_WORKING_COPY.getSource();
        int warmup = 5;
        int i = 0;
        while (i < warmup) {
            long startNanos = System.nanoTime();
            new DefaultCodeFormatter().format(8, source, 0, source.length(), 0, null);
            if (i == 0) {
                System.out.println("\tTime to format file (" + source.length() + " chars) = " + (System.nanoTime() - startNanos) / 1000000L + "ms");
            }
            ++i;
        }
        this.resetCounters();
        int measures = MEASURES_COUNT;
        int i2 = 0;
        while (i2 < measures) {
            this.runGc();
            this.startMeasuring();
            int j = 1;
            while (j < 10) {
                new DefaultCodeFormatter().format(8, source, 0, source.length(), 0, null);
                ++j;
            }
            this.stopMeasuring();
            ++i2;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testFormatDefaultBigFile() {
        this.tagAsSummary("Format big file with default options", false);
        String source = FORMAT_TYPE_SOURCE;
        int warmup = 5;
        int i = 0;
        while (i < warmup) {
            long startNanos = System.nanoTime();
            new DefaultCodeFormatter().format(8, source, 0, source.length(), 0, null);
            if (i == 0) {
                System.out.println("\tTime to format big file (" + source.length() + " chars) = " + (System.nanoTime() - startNanos) / 1000000L + "ms");
            }
            ++i;
        }
        this.resetCounters();
        int measures = MEASURES_COUNT;
        int i2 = 0;
        while (i2 < measures) {
            this.runGc();
            this.startMeasuring();
            new DefaultCodeFormatter().format(8, source, 0, source.length(), 0, null);
            this.stopMeasuring();
            ++i2;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected void resetCounters() {
    }
}

