/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.jdt.core.tests.performance.FullSourceWorkspaceTests;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;

public class FullSourceWorkspaceModelTests
extends FullSourceWorkspaceTests
implements IJavaSearchConstants {
    static int TESTS_COUNT = 0;
    private static final int WARMUP_COUNT = 50;
    private static final int FOLDERS_COUNT = 200;
    private static final int PACKAGES_COUNT = 200;
    static int TESTS_LENGTH;
    static final int JLS3_INTERNAL = 3;
    private static PrintStream[] LOG_STREAMS;
    static IPath BIG_PROJECT_TYPE_PATH;
    static ICompilationUnit WORKING_COPY;

    static {
        LOG_STREAMS = new PrintStream[DIM_NAMES.length];
    }

    public FullSourceWorkspaceModelTests(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = FullSourceWorkspaceModelTests.buildSuite(FullSourceWorkspaceModelTests.testClass());
        TESTS_LENGTH = TESTS_COUNT = suite.countTestCases();
        FullSourceWorkspaceModelTests.createPrintStream(FullSourceWorkspaceModelTests.testClass(), LOG_STREAMS, TESTS_COUNT, null);
        return suite;
    }

    private static Class testClass() {
        return FullSourceWorkspaceModelTests.class;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setUpBigProject();
        this.setUpBigJars();
    }

    private void setUpBigProject() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        String targetWorkspacePath = workspaceRoot.getLocation().toFile().toPath().normalize().toAbsolutePath().toString();
        long startNanos = System.nanoTime();
        File wkspDir = new File(targetWorkspacePath);
        File projectDir = new File(wkspDir, "BigProject");
        if (projectDir.exists()) {
            System.out.print("Add existing project BigProject in " + String.valueOf(workspaceRoot.getLocation()) + " to workspace...");
            IProject bigProject = workspaceRoot.getProject("BigProject");
            if (bigProject.exists()) {
                ENV.addProject(bigProject);
            } else {
                ENV.addProject("BigProject");
            }
            BIG_PROJECT = (JavaProject)ENV.getJavaProject("BigProject");
            BIG_PROJECT.setRawClasspath(BIG_PROJECT.getRawClasspath(), null);
        } else {
            System.out.println("Create project BigProject in " + String.valueOf(workspaceRoot.getLocation()) + ":");
            System.out.println("\t- create 200 folders x 200 packages...");
            String[] sourceFolders = new String[200];
            int i = 0;
            while (i < 200) {
                sourceFolders[i] = "src" + i;
                ++i;
            }
            String path = workspaceRoot.getLocation().toString() + "/BigProject/src";
            int i2 = 0;
            while (i2 < 200) {
                if (PRINT && i2 > 0 && i2 % 10 == 0) {
                    System.out.print("\t\t+ folder src" + i2 + "...");
                }
                long topNanos = System.nanoTime();
                int j = 0;
                while (j < 200) {
                    new File(path + i2 + "/org/eclipse/jdt/core/tests" + i2 + "/performance" + j).mkdirs();
                    ++j;
                }
                if (PRINT && i2 > 0 && i2 % 10 == 0) {
                    System.out.println("(" + (System.nanoTime() - topNanos) / 1000000L + " ms)");
                }
                ++i2;
            }
            System.out.println("\t\t=> global time = " + (System.nanoTime() - startNanos) / 1000000L + " ms)");
            startNanos = System.nanoTime();
            System.out.print("\t- add project to full source workspace...");
            ENV.addProject("BigProject");
            BIG_PROJECT = (JavaProject)this.createJavaProject("BigProject", sourceFolders, "bin", "1.4");
            BIG_PROJECT.setRawClasspath(BIG_PROJECT.getRawClasspath(), null);
        }
        System.out.println("(" + (System.nanoTime() - startNanos) / 1000000L + " ms)");
        System.out.print("\t- Create compilation unit with secondary type...");
        startNanos = System.nanoTime();
        BIG_PROJECT_TYPE_PATH = new Path("/BigProject/src199/org/eclipse/jdt/core/tests199/performance199/TestBigProject.java");
        IFile file = workspaceRoot.getFile(BIG_PROJECT_TYPE_PATH);
        if (!file.exists()) {
            String content = "package org.eclipse.jdt.core.tests199.performance199;\npublic class TestBigProject {\n\tclass Level1 {\n\t\tclass Level2 {\n\t\t\tclass Level3 {\n\t\t\t\tclass Level4 {\n\t\t\t\t\tclass Level5 {\n\t\t\t\t\t\tclass Level6 {\n\t\t\t\t\t\t\tclass Level7 {\n\t\t\t\t\t\t\t\tclass Level8 {\n\t\t\t\t\t\t\t\t\tclass Level9 {\n\t\t\t\t\t\t\t\t\t\tclass Level10 {}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\nclass TestSecondary {}\n";
            file.create(content.getBytes(), true, false, null);
        }
        WORKING_COPY = (ICompilationUnit)JavaCore.create((IFile)file);
        System.out.println("(" + (System.nanoTime() - startNanos) / 1000000L + "ms)");
    }

    private void setUpBigJars() throws Exception {
        File bigJar2;
        String bigProjectLocation = BIG_PROJECT.getResource().getLocation().toOSString();
        int size = 2000;
        File bigJar1 = new File(bigProjectLocation, "big1.jar");
        if (!bigJar1.exists()) {
            String[] pathAndContents = new String[size * 2];
            int i = 0;
            while (i < size) {
                pathAndContents[i * 2] = "/p" + i + "/X" + i + ".java";
                pathAndContents[i * 2 + 1] = "package p" + i + ";\npublic class X" + i + "{\n}";
                ++i;
            }
            Util.createJar((String[])pathAndContents, (String)bigJar1.getPath(), (String)"1.3");
            BIG_PROJECT.getProject().refreshLocal(2, null);
        }
        if (!(bigJar2 = new File(bigProjectLocation, "big2.jar")).exists()) {
            String[] pathAndContents = new String[size * 2];
            int i = 0;
            while (i < size) {
                pathAndContents[i * 2] = "/q" + i + "/Y" + i + ".java";
                pathAndContents[i * 2 + 1] = "package q" + i + ";\npublic class Y" + i + "{\n}";
                ++i;
            }
            Util.createJar((String[])pathAndContents, (String)bigJar2.getPath(), (String)"1.3");
            BIG_PROJECT.getProject().refreshLocal(2, null);
        }
    }

    @Override
    protected void tearDown() throws Exception {
        --TESTS_COUNT;
        if (LOG_DIR != null) {
            this.logPerfResult(LOG_STREAMS, TESTS_COUNT);
        }
        if (TESTS_COUNT == 0) {
            System.out.println("-------------------------------------");
            System.out.println("Model performance test statistics:");
            System.out.println("-------------------------------------\n");
        }
        super.tearDown();
    }

    protected void searchAllTypeNames(IJavaSearchScope scope) throws CoreException {
        class TypeNameCounter
        extends TypeNameRequestor {
            int count = 0;

            TypeNameCounter() {
            }

            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                ++this.count;
            }
        }
        TypeNameCounter requestor = new TypeNameCounter();
        new SearchEngine().searchAllTypeNames(null, 0, null, 1, 0, scope, (TypeNameRequestor)requestor, 3, null);
        FullSourceWorkspaceModelTests.assertTrue((String)"We should have found at least one type!", (requestor.count > 0 ? 1 : 0) != 0);
    }

    protected void assertElementEquals(String message, String expected, IJavaElement element) {
        String actual;
        String string = actual = element == null ? "<null>" : ((JavaElement)element).toStringWithAncestors(false);
        if (!expected.equals(actual)) {
            System.out.println(this.getName() + " actual result is:");
            System.out.println(actual + ",");
        }
        FullSourceWorkspaceModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void assertElementsEqual(String message, String expected, IJavaElement[] elements) {
        this.assertElementsEqual(message, expected, elements, false);
    }

    protected void assertElementsEqual(String message, String expected, IJavaElement[] elements, boolean showResolvedInfo) {
        StringBuilder buffer = new StringBuilder();
        if (elements != null) {
            int i = 0;
            int length = elements.length;
            while (i < length) {
                JavaElement element = (JavaElement)elements[i];
                if (element == null) {
                    buffer.append("<null>");
                } else {
                    buffer.append(element.toStringWithAncestors(showResolvedInfo));
                }
                if (i != length - 1) {
                    buffer.append("\n");
                }
                ++i;
            }
        } else {
            buffer.append("<null>");
        }
        String actual = buffer.toString();
        if (!expected.equals(actual)) {
            System.out.println(this.getName() + " actual result is:");
            System.out.println(actual + ",");
        }
        FullSourceWorkspaceModelTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    private void touchFiles(File[] files) {
        int index = 0;
        while (index < files.length) {
            files[index].setLastModified(System.currentTimeMillis());
            ++index;
        }
    }

    private IJavaProject createJavaProject(String name) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project.exists()) {
            project.delete(true, null);
        }
        project.create(null);
        project.open(null);
        IProjectDescription description = project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        project.setDescription(description, null);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        javaProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), null, null)}, null);
        return javaProject;
    }

    private NameLookup getNameLookup(JavaProject project) throws JavaModelException {
        return project.newNameLookup(null);
    }

    public void testNameLookupFindKnownType() throws CoreException {
        this.waitUntilIndexesReady();
        String fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).toString();
        fullQualifiedName = fullQualifiedName.replace('/', '.');
        int i = 0;
        while (i < 50) {
            NameLookup nameLookup = BIG_PROJECT.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            IType type = nameLookup.findType(fullQualifiedName, false, 0x100001E);
            if (i == 0) {
                FullSourceWorkspaceModelTests.assertNotNull((String)("We should find type '" + fullQualifiedName + "' in project BigProject"), (Object)type);
            }
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 50000) {
                NameLookup nameLookup = BIG_PROJECT.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                nameLookup.findType(fullQualifiedName, false, 0x100001E);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testNameLookupFindKnownSecondaryType() throws CoreException {
        this.waitUntilIndexesReady();
        Object fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).removeLastSegments(1).toString();
        fullQualifiedName = ((String)fullQualifiedName).replace('/', '.') + ".TestSecondary";
        int i = 0;
        while (i < 50) {
            NameLookup nameLookup = BIG_PROJECT.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            IType type = nameLookup.findType((String)fullQualifiedName, false, 0x100001E);
            if (i == 0 && LOG_VERSION.compareTo("v_623") > 0) {
                FullSourceWorkspaceModelTests.assertNotNull((String)("We should find type '" + (String)fullQualifiedName + "' in project BigProject"), (Object)type);
            }
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 50000) {
                NameLookup nameLookup = BIG_PROJECT.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                nameLookup.findType((String)fullQualifiedName, false, 0x100001E);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testNameLookupFindUnknownType() throws CoreException {
        this.waitUntilIndexesReady();
        Object fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).removeLastSegments(1).toString();
        fullQualifiedName = ((String)fullQualifiedName).replace('/', '.') + ".Unknown";
        int i = 0;
        while (i < 50) {
            NameLookup nameLookup = BIG_PROJECT.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            IType type = nameLookup.findType((String)fullQualifiedName, false, 0x100001E);
            if (i == 0) {
                FullSourceWorkspaceModelTests.assertNull((String)"We should not find an unknown type in project BigProject", (Object)type);
            }
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 50000) {
                NameLookup nameLookup = BIG_PROJECT.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                nameLookup.findType((String)fullQualifiedName, false, 0x100001E);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testProjectFindKnownType() throws CoreException {
        this.tagAsSummary("Find known type in project", false);
        this.waitUntilIndexesReady();
        String fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).toString();
        fullQualifiedName = fullQualifiedName.replace('/', '.');
        int i = 0;
        while (i < 50) {
            IType type = BIG_PROJECT.findType(fullQualifiedName);
            if (i == 0) {
                FullSourceWorkspaceModelTests.assertNotNull((String)("We should find type '" + fullQualifiedName + "' in project BigProject"), (Object)type);
            }
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 50000) {
                BIG_PROJECT.findType(fullQualifiedName);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testProjectFindKnownMemberType() throws CoreException {
        this.tagAsSummary("Find known member type in project", false);
        this.waitUntilIndexesReady();
        Object fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).toString();
        fullQualifiedName = ((String)fullQualifiedName).replace('/', '.');
        int i = 1;
        while (i <= 10) {
            fullQualifiedName = (String)fullQualifiedName + ".Level" + i;
            ++i;
        }
        i = 0;
        while (i < 50) {
            IType type = BIG_PROJECT.findType((String)fullQualifiedName);
            if (i == 0) {
                FullSourceWorkspaceModelTests.assertNotNull((String)("We should find type '" + (String)fullQualifiedName + "' in project BigProject"), (Object)type);
            }
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 4000) {
                BIG_PROJECT.findType((String)fullQualifiedName);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testProjectFindKnownSecondaryType() throws CoreException {
        this.tagAsSummary("Find known secondary type in project", false);
        this.waitUntilIndexesReady();
        Object fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).removeLastSegments(1).toString();
        fullQualifiedName = ((String)fullQualifiedName).replace('/', '.') + ".TestSecondary";
        int i = 0;
        while (i < 50) {
            BIG_PROJECT.findType((String)fullQualifiedName);
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 1000) {
                BIG_PROJECT.findType((String)fullQualifiedName);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testProjectFindUnknownType() throws CoreException {
        this.tagAsSummary("Find unknown type in project", false);
        this.waitUntilIndexesReady();
        Object fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).removeLastSegments(1).toString();
        fullQualifiedName = ((String)fullQualifiedName).replace('/', '.') + ".Unknown";
        int i = 0;
        while (i < 50) {
            IType type = BIG_PROJECT.findType((String)fullQualifiedName);
            FullSourceWorkspaceModelTests.assertNull((String)"We should not find an unknown type in project BigProject", (Object)type);
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 2000) {
                BIG_PROJECT.findType((String)fullQualifiedName);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testProjectFindUnknownTypeAfterSetClasspath() throws CoreException {
        this.tagAsSummary("Find unknown type in project after resetting classpath", false);
        this.waitUntilIndexesReady();
        Object fullQualifiedName = BIG_PROJECT_TYPE_PATH.removeFileExtension().removeFirstSegments(2).removeLastSegments(1).toString();
        fullQualifiedName = ((String)fullQualifiedName).replace('/', '.') + ".Unknown";
        IType type = BIG_PROJECT.findType((String)fullQualifiedName);
        FullSourceWorkspaceModelTests.assertNull((String)"We should not find an unknown type in project BigProject", (Object)type);
        BIG_PROJECT.setRawClasspath(BIG_PROJECT.getRawClasspath(), null);
        int i = 0;
        while (i < 50) {
            BIG_PROJECT.findType((String)fullQualifiedName);
            ++i;
        }
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int n = 0;
            while (n < 2000) {
                BIG_PROJECT.findType((String)fullQualifiedName);
                ++n;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPerfReconcile() throws CoreException {
        this.tagAsGlobalSummary("Reconcile editor change", true);
        this.waitUntilIndexesReady();
        ICompilationUnit workingCopy = null;
        try {
            final AbstractJavaModelTests.ProblemRequestor requestor = new AbstractJavaModelTests.ProblemRequestor();
            WorkingCopyOwner owner = new WorkingCopyOwner(){

                public IProblemRequestor getProblemRequestor(ICompilationUnit cu) {
                    return requestor;
                }
            };
            workingCopy = PARSER_WORKING_COPY.getWorkingCopy(owner, null);
            int warmup = 10;
            int i = 0;
            while (i < warmup) {
                CompilationUnit unit = workingCopy.reconcile(3, true, null, null);
                FullSourceWorkspaceModelTests.assertNotNull((String)"Compilation Unit should not be null!", (Object)unit);
                FullSourceWorkspaceModelTests.assertNotNull((String)"Bindings were not resolved!", (Object)unit.getPackage().resolveBinding());
                ++i;
            }
            this.resetCounters();
            int iterations = 2;
            int i2 = 0;
            while (i2 < MEASURES_COUNT) {
                this.runGc();
                this.startMeasuring();
                int n = 0;
                while (n < iterations) {
                    workingCopy.reconcile(3, true, null, null);
                    ++n;
                }
                this.stopMeasuring();
                ++i2;
            }
        }
        finally {
            workingCopy.discardWorkingCopy();
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPerfReconcileBigFileWithSyntaxError() throws JavaModelException {
        this.tagAsSummary("Reconcile editor change on big file with syntax error", false);
        String method = "() {\n  bar(\n    \"public class X <E extends Exception> {\\n\" + \r\n\t \"    void foo(E e) throws E {\\n\" + \r\n\t \"        throw e;\\n\" + \r\n\t \"    }\\n\" + \r\n\t \"    void bar(E e) {\\n\" + \r\n\t \"        try {\\n\" + \r\n\t \"            foo(e);\\n\" + \r\n\t \"        } catch(Exception ex) {\\n\" + \r\n\t \"\t        System.out.println(\\\"SUCCESS\\\");\\n\" + \r\n\t \"        }\\n\" + \r\n\t \"    }\\n\" + \r\n\t \"    public static void main(String[] args) {\\n\" + \r\n\t \"        new X<Exception>().bar(new Exception());\\n\" + \r\n\t \"    }\\n\" + \r\n\t \"}\\n\"  );\n}\n";
        StringBuilder bigContents = new StringBuilder();
        bigContents.append("public class BigCU {\n");
        int fooIndex = 0;
        while (fooIndex < 2000) {
            bigContents.append("public void foo");
            bigContents.append(fooIndex++);
            bigContents.append(method);
        }
        ICompilationUnit workingCopy = null;
        try {
            workingCopy = (ICompilationUnit)JavaCore.create((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("/BigProject/src/org/eclipse/jdt/core/tests/BigCu.java")));
            workingCopy.becomeWorkingCopy(null);
            int warmup = 5;
            int i = 0;
            while (i < warmup) {
                workingCopy.getBuffer().setContents(bigContents.append("a").toString());
                workingCopy.reconcile(3, false, null, null);
                ++i;
            }
            this.resetCounters();
            i = 0;
            while (i < MEASURES_COUNT) {
                workingCopy.getBuffer().setContents(bigContents.append("a").toString());
                this.runGc();
                this.startMeasuring();
                workingCopy.reconcile(3, false, null, null);
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
        }
    }

    public void testReconcileDuplicates() throws JavaModelException {
        this.tagAsSummary("Reconcile editor change on file with lots of duplicates", false);
        StringBuilder contents = new StringBuilder();
        contents.append("public class CUWithDuplicates {\n");
        int fooIndex = 0;
        while (fooIndex < 2000) {
            contents.append("  void foo() {}\n");
            contents.append(fooIndex++);
        }
        contents.append("} //");
        ICompilationUnit workingCopy = null;
        try {
            workingCopy = (ICompilationUnit)JavaCore.create((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("/BigProject/src/CUWithDuplicates.java")));
            workingCopy.becomeWorkingCopy(null);
            int warmup = 5;
            int i = 0;
            while (i < warmup) {
                workingCopy.getBuffer().setContents(contents.append('a').toString());
                workingCopy.reconcile(3, false, null, null);
                ++i;
            }
            this.resetCounters();
            i = 0;
            while (i < MEASURES_COUNT) {
                workingCopy.getBuffer().setContents(contents.append('a').toString());
                this.runGc();
                this.startMeasuring();
                workingCopy.reconcile(3, false, null, null);
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
        }
    }

    public void testPerfDeleteLotsOfMembersAndReconcile() throws JavaModelException {
        this.tagAsSummary("Reconcile editor change after deleting lots of members", false);
        StringBuilder contents = new StringBuilder();
        contents.append("public class LotsOfMembers {\n");
        int fooIndex = 0;
        while (fooIndex < 15000) {
            contents.append("  void foo");
            contents.append(fooIndex++);
            contents.append("() {}\n");
        }
        contents.append("}");
        String oldContents = contents.toString();
        String newContents = "public class LotsOfMembers {\n}";
        ICompilationUnit workingCopy = null;
        try {
            workingCopy = (ICompilationUnit)JavaCore.create((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("/BigProject/src/LotsOfMembers.java")));
            workingCopy.becomeWorkingCopy(null);
            int warmup = 5;
            int i = 0;
            while (i < warmup) {
                workingCopy.getBuffer().setContents(oldContents);
                workingCopy.reconcile(3, false, null, null);
                workingCopy.getBuffer().setContents(newContents);
                workingCopy.reconcile(3, false, null, null);
                ++i;
            }
            this.resetCounters();
            i = 0;
            while (i < MEASURES_COUNT) {
                workingCopy.getBuffer().setContents(oldContents);
                workingCopy.reconcile(3, false, null, null);
                workingCopy.getBuffer().setContents(newContents);
                this.runGc();
                this.startMeasuring();
                workingCopy.reconcile(3, false, null, null);
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            if (workingCopy != null) {
                workingCopy.discardWorkingCopy();
            }
        }
    }

    public void testPerfBatchCreatePackageAndReconcile() throws CoreException {
        this.tagAsSummary("Reconcile editor change after creating a package fragment in a batch operation", false);
        IJavaProject project = null;
        try {
            project = this.createJavaProject("P234718");
            IFile bigJar1 = BIG_PROJECT.getProject().getFile("big1.jar");
            IFile bigJar2 = BIG_PROJECT.getProject().getFile("big2.jar");
            project.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)project.getPath()), JavaCore.newLibraryEntry((IPath)bigJar1.getFullPath(), null, null), JavaCore.newLibraryEntry((IPath)bigJar2.getFullPath(), null, null)}, null);
            final IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject());
            ICompilationUnit workingCopy = root.getPackageFragment("").createCompilationUnit("X.java", "public class  {\n}", false, null);
            workingCopy.becomeWorkingCopy(null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            try {
                final ICompilationUnit copy = workingCopy;
                Object runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        root.createPackageFragment("p2", false, monitor);
                        copy.reconcile(3, true, null, monitor);
                        int warmup = 10;
                        int i = 0;
                        while (i < warmup) {
                            copy.reconcile(3, true, null, monitor);
                            ++i;
                        }
                    }
                };
                try {
                    JavaCore.run((IWorkspaceRunnable)runnable, null);
                }
                finally {
                    root.getPackageFragment("p2").delete(false, null);
                }
                this.resetCounters();
                runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        root.createPackageFragment("p2", false, monitor);
                        copy.reconcile(3, true, null, monitor);
                        int iterations = 10;
                        FullSourceWorkspaceModelTests.this.startMeasuring();
                        int n = 0;
                        while (n < iterations) {
                            copy.reconcile(3, true, null, monitor);
                            ++n;
                        }
                        FullSourceWorkspaceModelTests.this.stopMeasuring();
                    }
                };
                int i = 0;
                while (i < MEASURES_COUNT) {
                    this.runGc();
                    try {
                        JavaCore.run((IWorkspaceRunnable)runnable, null);
                    }
                    finally {
                        root.getPackageFragment("p2").delete(false, null);
                    }
                    ++i;
                }
            }
            finally {
                workingCopy.discardWorkingCopy();
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            if (project != null) {
                project.getProject().delete(true, null);
            }
        }
    }

    public void testPerfSearchAllTypeNamesAndReconcile() throws CoreException {
        this.tagAsSummary("Reconcile editor change and complete", true);
        this.waitUntilIndexesReady();
        ICompilationUnit workingCopy = null;
        try {
            final AbstractJavaModelTests.ProblemRequestor requestor = new AbstractJavaModelTests.ProblemRequestor();
            WorkingCopyOwner owner = new WorkingCopyOwner(){

                public IProblemRequestor getProblemRequestor(ICompilationUnit cu) {
                    return requestor;
                }
            };
            workingCopy = PARSER_WORKING_COPY.getWorkingCopy(owner, null);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{JDT_CORE_PROJECT});
            int warmup = 10;
            int i = 0;
            while (i < warmup) {
                this.searchAllTypeNames(scope);
                CompilationUnit unit = workingCopy.reconcile(3, true, null, null);
                if (i == 0) {
                    FullSourceWorkspaceModelTests.assertNotNull((String)"Compilation Unit should not be null!", (Object)unit);
                    FullSourceWorkspaceModelTests.assertNotNull((String)"Bindings were not resolved!", (Object)unit.getPackage().resolveBinding());
                }
                ++i;
            }
            int iterations = 2;
            this.resetCounters();
            int i2 = 0;
            while (i2 < MEASURES_COUNT) {
                this.runGc();
                this.startMeasuring();
                int n = 0;
                while (n < iterations) {
                    this.searchAllTypeNames(scope);
                    workingCopy.reconcile(3, true, null, null);
                    ++n;
                }
                this.stopMeasuring();
                ++i2;
            }
        }
        finally {
            workingCopy.discardWorkingCopy();
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testPopulateTwoBigJars() throws CoreException {
        IJavaProject project = null;
        try {
            int j;
            project = this.createJavaProject("HugeJarProject");
            IFile bigJar1 = BIG_PROJECT.getProject().getFile("big1.jar");
            IFile bigJar2 = BIG_PROJECT.getProject().getFile("big2.jar");
            project.setRawClasspath(new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)bigJar1.getFullPath(), null, null), JavaCore.newLibraryEntry((IPath)bigJar2.getFullPath(), null, null)}, null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            IPackageFragmentRoot root1 = project.getPackageFragmentRoot((IResource)bigJar1);
            IPackageFragmentRoot root2 = project.getPackageFragmentRoot((IResource)bigJar2);
            int max = 20;
            int warmup = 5;
            int i = 0;
            while (i < warmup) {
                project.close();
                j = 0;
                while (j < max) {
                    root1.getPackageFragment("p" + j).open(null);
                    root2.getPackageFragment("q" + j).open(null);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < MEASURES_COUNT) {
                project.close();
                this.runGc();
                this.startMeasuring();
                j = 0;
                while (j < max) {
                    root1.getPackageFragment("p" + j).open(null);
                    root2.getPackageFragment("q" + j).open(null);
                    ++j;
                }
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            if (project != null) {
                project.getProject().delete(false, null);
            }
        }
    }

    public void testSeekPackageFragments() throws CoreException {
        FullSourceWorkspaceModelTests.assertNotNull((String)"We should have the 'BigProject' in workspace!", (Object)BIG_PROJECT);
        class PackageRequestor
        implements IJavaElementRequestor {
            ArrayList pkgs = new ArrayList();

            PackageRequestor() {
            }

            public void acceptField(IField field) {
            }

            public void acceptInitializer(IInitializer initializer) {
            }

            public void acceptMemberType(IType type) {
            }

            public void acceptMethod(IMethod method) {
            }

            public void acceptPackageFragment(IPackageFragment packageFragment) {
                if (this.pkgs != null) {
                    this.pkgs.add(packageFragment);
                }
            }

            public void acceptType(IType type) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void acceptModule(IModuleDescription module) {
            }
        }
        PackageRequestor requestor = new PackageRequestor();
        int i = 0;
        while (i < 50) {
            this.getNameLookup(BIG_PROJECT).seekPackageFragments("org.eclipse.jdt.core.tests78.performance5", false, (IJavaElementRequestor)requestor);
            if (i == 0) {
                int size = requestor.pkgs.size();
                IJavaElement[] result = new IJavaElement[size];
                requestor.pkgs.toArray(result);
                this.assertElementsEqual("Unexpected packages", "org.eclipse.jdt.core.tests78.performance5 [in src78 [in BigProject]]", result);
            }
            ++i;
        }
        requestor.pkgs = null;
        this.resetCounters();
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            int j = 0;
            while (j < 50000) {
                this.getNameLookup(BIG_PROJECT).seekPackageFragments("org.eclipse.jdt.core.tests" + i + "0.performance" + i, false, (IJavaElementRequestor)requestor);
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testCloseProjects() throws JavaModelException {
        int j;
        this.tagAsSummary("Close all workspace projects", false);
        int length = ALL_PROJECTS.length;
        int wmax = 5;
        int i = 0;
        while (i < wmax) {
            j = 0;
            while (j < length) {
                ENV.closeProject(ALL_PROJECTS[j].getPath());
                ++j;
            }
            j = 0;
            while (j < length) {
                ENV.openProject(ALL_PROJECTS[j].getPath());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.waitUntilIndexesReady();
            this.runGc();
            this.startMeasuring();
            j = 0;
            while (j < length) {
                ENV.closeProject(ALL_PROJECTS[j].getPath());
                ++j;
            }
            this.stopMeasuring();
            j = 0;
            while (j < length) {
                ENV.openProject(ALL_PROJECTS[j].getPath());
                ++j;
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testCreateJavaElement() throws CoreException {
        int j;
        IFile file = (IFile)WORKING_COPY.getResource();
        this.getNameLookup(BIG_PROJECT);
        int warmup = 5;
        int iterations = 5000;
        int i = 0;
        while (i < warmup) {
            j = 0;
            while (j < iterations) {
                JavaCore.create((IFile)file);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            this.startMeasuring();
            j = 0;
            while (j < iterations) {
                JavaCore.create((IFile)file);
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testInitJDTPlugin() throws JavaModelException, CoreException {
        this.tagAsSummary("JDT/Core plugin initialization", true);
        this.setComment(1, "Bug 338649:Extra check for source attachment in missing drive causing regression");
        int wmax = 10;
        int i = 0;
        while (i < wmax) {
            this.simulateExitRestart();
            JavaCore.initializeAfterLoad(null);
            this.waitUntilIndexesReady();
            ++i;
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.simulateExit();
            this.runGc();
            this.startMeasuring();
            this.simulateRestart();
            JavaCore.initializeAfterLoad(null);
            this.waitUntilIndexesReady();
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    /*
     * Unable to fully structure code
     */
    public void testFindType() throws CoreException {
        model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        existingProjects = model.getJavaProjects();
        try {
            i = 0;
            length = existingProjects.length;
            while (i < length) {
                existingProjects[i].getProject().close(null);
                ++i;
            }
            max = 20;
            projects = new IJavaProject[max];
            i = 0;
            while (i < max) {
                projects[i] = this.createJavaProject("FindType" + i);
                ++i;
            }
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            try {
                warmup = 5;
                i = 0;
                while (i < warmup) {
                    model.close();
                    j = 0;
                    while (j < max) {
                        projects[j].findType("java.lang.Object");
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < FullSourceWorkspaceModelTests.MEASURES_COUNT) {
                    model.close();
                    this.runGc();
                    this.startMeasuring();
                    j = 0;
                    while (j < max) {
                        projects[j].findType("java.lang.Object");
                        ++j;
                    }
                    this.stopMeasuring();
                    ++i;
                }
                this.commitMeasurements();
                this.assertPerformance();
            }
            finally {
                i = 0;
                ** while (i < max)
            }
lbl-1000:
            // 1 sources

            {
                projects[i].getProject().delete(false, null);
                ++i;
                continue;
            }
lbl55:
            // 1 sources

        }
        finally {
            i = 0;
            length = existingProjects.length;
            ** while (i < length)
        }
lbl-1000:
        // 1 sources

        {
            existingProjects[i].getProject().open(null);
            ++i;
            continue;
        }
lbl63:
        // 1 sources

    }

    public void testGetSourceBigJarNoAttachment() throws CoreException {
        IJavaProject project = null;
        try {
            int j;
            project = this.createJavaProject("HugeJarProject");
            IFile bigJar1 = BIG_PROJECT.getProject().getFile("big1.jar");
            project.setRawClasspath(new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)bigJar1.getFullPath(), null, null)}, null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)bigJar1);
            IClassFile classFile = root.getPackageFragment("p0").getClassFile("X0.class");
            int max = 20;
            int warmup = 5;
            int i = 0;
            while (i < warmup) {
                j = 0;
                while (j < max) {
                    root.close();
                    classFile.getSource();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < MEASURES_COUNT) {
                this.runGc();
                this.startMeasuring();
                j = 0;
                while (j < max) {
                    root.close();
                    classFile.getSource();
                    ++j;
                }
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            if (project != null) {
                project.getProject().delete(false, null);
            }
        }
    }

    public void testReopenSingleProject() throws CoreException {
        this.tagAsSummary("Reopen a single project in a workspace", false);
        long startNanos = 0L;
        if (PRINT) {
            System.out.print("Close all Eclipse projects...");
            startNanos = System.nanoTime();
        }
        int length = ALL_PROJECTS.length;
        int j = 0;
        while (j < length) {
            ALL_PROJECTS[j].getProject().close(null);
            ++j;
        }
        this.waitUntilIndexesReady();
        this.waitForAutoBuild();
        if (PRINT) {
            System.out.println((System.nanoTime() - startNanos) / 1000000L + "ms");
        }
        if (PRINT) {
            System.out.print("Warmup test...");
            startNanos = System.nanoTime();
        }
        int warmup = 5;
        int i = 0;
        while (i < 5) {
            BIG_PROJECT.getProject().close(null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            BIG_PROJECT.getProject().open(null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            this.waitForManualRefresh();
            ++i;
        }
        if (PRINT) {
            System.out.println((System.nanoTime() - startNanos) / 1000000L + "ms");
        }
        if (PRINT) {
            System.out.println();
            System.out.println("Start measures:");
            startNanos = System.nanoTime();
        }
        i = 0;
        while (i < MEASURES_COUNT) {
            this.runGc();
            BIG_PROJECT.getProject().close(null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            this.startMeasuring();
            BIG_PROJECT.getProject().open(null);
            this.waitUntilIndexesReady();
            this.waitForAutoBuild();
            this.waitForManualRefresh();
            this.stopMeasuring();
            ++i;
        }
        if (PRINT) {
            System.out.println("\ttotal time: " + (System.nanoTime() - startNanos) / 1000000L + "ms");
        }
        if (PRINT) {
            System.out.println();
            System.out.println("Commit measures:");
            startNanos = System.nanoTime();
        }
        this.commitMeasurements();
        this.assertPerformance();
        if (PRINT) {
            System.out.print("Reopen Eclipse projects...");
            startNanos = System.nanoTime();
        }
        i = 0;
        while (i < length) {
            ALL_PROJECTS[i].getProject().open(null);
            ++i;
        }
        this.waitUntilIndexesReady();
        this.waitForAutoBuild();
        this.waitForManualRefresh();
        this.runGc();
        if (PRINT) {
            System.out.println((System.nanoTime() - startNanos) / 1000000L + "ms");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void testRefreshExternalArchives() throws Exception {
        jarCount = 100;
        files = new File[jarCount];
        model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        oldClasspath = FullSourceWorkspaceModelTests.BIG_PROJECT.getRawClasspath();
        try {
            classpath = new IClasspathEntry[jarCount];
            index = 0;
            while (index < jarCount) {
                filePath = this.getExternalResourcePath("lib" + index + ".jar");
                Util.createJar((String[])new String[0], (String[])new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n"}, (String)filePath, (String)"1.4");
                classpath[index] = JavaCore.newLibraryEntry((IPath)new Path(filePath), null, null);
                files[index] = new File(filePath);
                ++index;
            }
            FullSourceWorkspaceModelTests.BIG_PROJECT.setRawClasspath(classpath, null);
            max = 20;
            warmup = 5;
            i = 0;
            while (i < warmup) {
                j = 0;
                while (j < max) {
                    this.touchFiles(files);
                    model.refreshExternalArchives(new IJavaElement[]{FullSourceWorkspaceModelTests.BIG_PROJECT}, null);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < FullSourceWorkspaceModelTests.MEASURES_COUNT) {
                this.runGc();
                this.startMeasuring();
                j = 0;
                while (j < max) {
                    this.touchFiles(files);
                    model.refreshExternalArchives(new IJavaElement[]{FullSourceWorkspaceModelTests.BIG_PROJECT}, null);
                    ++j;
                }
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            FullSourceWorkspaceModelTests.BIG_PROJECT.setRawClasspath(oldClasspath, null);
            index = 0;
            ** while (index < files.length)
        }
lbl-1000:
        // 1 sources

        {
            files[index].delete();
            ++index;
            continue;
        }
lbl52:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void testResolveClasspath() throws Exception {
        jarCount = 100;
        libraryFiles = new File[jarCount];
        srcAttachmentFiles = new File[jarCount];
        oldClasspath = FullSourceWorkspaceModelTests.BIG_PROJECT.getRawClasspath();
        try {
            classpath = new IClasspathEntry[jarCount];
            index = 0;
            while (index < jarCount) {
                libraryFilePath = this.getExternalResourcePath("lib" + index + ".jar");
                Util.createJar((String[])new String[0], (String[])new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n"}, (String)libraryFilePath, (String)"1.4");
                libraryFiles[index] = new File(libraryFilePath);
                srcAttachmentFilePath = this.getExternalResourcePath("lib" + index + "-src.jar");
                Util.createJar((String[])new String[0], (String[])new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n"}, (String)srcAttachmentFilePath, (String)"1.4");
                srcAttachmentFiles[index] = new File(srcAttachmentFilePath);
                classpath[index] = JavaCore.newLibraryEntry((IPath)new Path(libraryFilePath), (IPath)new Path(srcAttachmentFilePath), null);
                ++index;
            }
            FullSourceWorkspaceModelTests.BIG_PROJECT.setRawClasspath(classpath, null);
            max = 20;
            warmup = 5;
            i = 0;
            while (i < warmup) {
                j = 0;
                while (j < max) {
                    FullSourceWorkspaceModelTests.BIG_PROJECT.resolveClasspath(classpath);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < FullSourceWorkspaceModelTests.MEASURES_COUNT) {
                this.runGc();
                this.startMeasuring();
                j = 0;
                while (j < max) {
                    FullSourceWorkspaceModelTests.BIG_PROJECT.resolveClasspath(classpath);
                    ++j;
                }
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            FullSourceWorkspaceModelTests.BIG_PROJECT.setRawClasspath(oldClasspath, null);
            index = 0;
            ** while (index < libraryFiles.length)
        }
lbl-1000:
        // 1 sources

        {
            libraryFiles[index].delete();
            srcAttachmentFiles[index].delete();
            ++index;
            continue;
        }
lbl57:
        // 1 sources

    }

    @Override
    protected String getExternalPath() {
        return super.getExternalPath();
    }

    public void testGetAllPackageFragmentRoots() throws Exception {
        int jarCount = 100;
        IClasspathEntry[] oldClasspath = BIG_PROJECT.getRawClasspath();
        try {
            int j;
            IClasspathEntry[] classpath = new IClasspathEntry[jarCount];
            int index = 0;
            while (index < jarCount) {
                String filePath = this.getExternalResourcePath("lib" + index + ".jar");
                Util.createJar((String[])new String[0], (String[])new String[]{"META-INF/MANIFEST.MF", "Manifest-Version: 1.0\n"}, (String)filePath, (String)"1.4");
                classpath[index] = JavaCore.newLibraryEntry((IPath)new Path(filePath), null, null);
                ++index;
            }
            BIG_PROJECT.setRawClasspath(classpath, null);
            IFile file = (IFile)WORKING_COPY.getResource();
            int max = 20;
            int warmup = 5;
            int i = 0;
            while (i < warmup) {
                j = 0;
                while (j < max) {
                    file.touch(null);
                    BIG_PROJECT.getAllPackageFragmentRoots();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < MEASURES_COUNT) {
                this.runGc();
                this.startMeasuring();
                j = 0;
                while (j < max) {
                    file.touch(null);
                    BIG_PROJECT.getAllPackageFragmentRoots();
                    ++j;
                }
                this.stopMeasuring();
                ++i;
            }
            this.commitMeasurements();
            this.assertPerformance();
        }
        finally {
            BIG_PROJECT.setRawClasspath(oldClasspath, null);
        }
    }

    protected void resetCounters() {
    }

    class JavaSearchResultCollector
    extends SearchRequestor {
        int count = 0;

        JavaSearchResultCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            ++this.count;
        }
    }
}

