/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.tests.builder.TestingEnvironment;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.test.performance.Dimension;

public class PTBKeyHashCalculationTest
extends TestCase {
    private TestingEnvironment env;

    public PTBKeyHashCalculationTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PTBKeyHashCalculationTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.env == null) {
            this.env = new TestingEnvironment();
            this.env.openEmptyWorkspace();
        }
        this.env.resetWorkspace();
        IPath projectPath = this.env.addProject("PTBKeyTest", "1.8");
        this.env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.env.removePackageFragmentRoot(projectPath, "");
        this.env.addPackageFragmentRoot(projectPath, "src");
        this.env.setOutputFolder(projectPath, "bin");
        IJavaProject javaProj = this.env.getJavaProject(projectPath);
        IProject proj = javaProj.getProject();
        IPath projPath = proj.getFullPath();
        IPath root = projPath.append("src");
        this.env.addClass(root, "test", "MainClass", "package test;\npublic abstract class MainClass {\n    protected Object createField(Object o) { return null; }\n}");
        this.env.addClass(root, "test", "BaseClass", "package test;\nimport java.util.Iterator;\npublic class BaseClass<I extends BaseClass<I, J>, J> {\n    protected abstract class MyIterator implements Iterator<I> {\n        @Override public boolean hasNext() { return false; }\n        @Override public I next() { return null; }\n    }\n    protected class SomeOtherClass {\n        public final void doSomething() { System.out.println(\"test\"); }\n    }\n    private class OtherIterator extends MyIterator {\n        @Override public I next() { return null; }\n    }\n}");
        int i = 0;
        while (i < 1000) {
            StringBuilder sb = new StringBuilder();
            sb.append("package example;\n").append("import test.BaseClass;\n").append("public class TestClass").append(i).append(" extends MainClass {\n");
            int j = 0;
            while (j < 10) {
                sb.append("\tpublic final class Inner").append(j).append(" extends BaseClass<Inner").append(j).append(", String> {\n");
                int x = 0;
                while (x < 2) {
                    sb.append("\t\tpublic final class Inner").append(j).append("_").append(x).append(" extends BaseClass<Inner").append(j).append("_").append(x).append(", String> {\n");
                    int y = 0;
                    while (y < 30) {
                        sb.append("\t\t\tpublic final Object field_").append(j).append("_").append(x).append("_").append(y).append(" = createField(this);\n");
                        ++y;
                    }
                    sb.append("\t\t}\n");
                    ++x;
                }
                int y = 0;
                while (y < 30) {
                    sb.append("\t\tpublic final Object field_").append(j).append("_").append(y).append(" = createField(this);\n");
                    ++y;
                }
                sb.append("\t}\n");
                ++j;
            }
            sb.append("}");
            this.env.addClass(root, "test", "TestClass" + i, sb.toString());
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.env.resetWorkspace();
        JavaCore.setOptions((Hashtable)JavaCore.getDefaultOptions());
    }

    public void testHashCalculation() throws Exception {
        this.tagAsSummary("PTBKey hash calculation", Dimension.CPU_TIME);
        int idx = 0;
        while (idx < 2) {
            this.startMeasuring();
            this.env.fullBuild();
            this.stopMeasuring();
            ++idx;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

