/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.performance.util;

import java.text.NumberFormat;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.internal.performance.eval.StatisticsUtil;

public final class Statistics {
    static final NumberFormat DOUBLE_FORMAT = NumberFormat.getNumberInstance();
    StatisticsSession session;
    int count;
    long[][] measures;
    long[] min;
    long[] max;
    static final Dim[] DIMENSIONS;

    static {
        DOUBLE_FORMAT.setMaximumFractionDigits(1);
        DIMENSIONS = new Dim[]{InternalDimensions.CPU_TIME, InternalDimensions.ELAPSED_PROCESS, InternalDimensions.USED_JAVA_HEAP};
    }

    public Statistics(DataPoint[] dataPoints) {
        this.session = new StatisticsSession(dataPoints);
        this.count = dataPoints.length / 2;
        int dimLength = DIMENSIONS.length;
        this.measures = new long[dimLength][this.count];
        this.min = new long[dimLength];
        this.max = new long[dimLength];
        int i = 0;
        while (i < DIMENSIONS.length) {
            this.min[i] = Long.MAX_VALUE;
            this.max[i] = 0L;
            int j = 0;
            while (j < this.count) {
                long measure;
                this.measures[i][j] = measure = dataPoints[2 * j + 1].getScalar(DIMENSIONS[i]).getMagnitude() - dataPoints[2 * j].getScalar(DIMENSIONS[i]).getMagnitude();
                if (measure < this.min[i]) {
                    this.min[i] = measure;
                }
                if (measure > this.max[i]) {
                    this.max[i] = measure;
                }
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        int length = DIMENSIONS.length;
        int idx = 0;
        while (idx < length) {
            this.dimToString(idx, buffer);
            ++idx;
        }
        return buffer.toString();
    }

    public String toString(int dimIndex) {
        StringBuilder buffer = new StringBuilder();
        this.dimToString(dimIndex, buffer);
        return buffer.toString();
    }

    public String elapsedProcessToString() {
        StringBuilder buffer = new StringBuilder();
        this.dimToString(1, buffer);
        return buffer.toString();
    }

    void dimToString(int idx, StringBuilder buffer) {
        Dim dim = DIMENSIONS[idx];
        buffer.append(dim.getName());
        buffer.append(": n=");
        buffer.append(this.count);
        buffer.append(", sum=");
        buffer.append(this.session.getSum(dim));
        buffer.append(", av=");
        buffer.append(this.session.getAverage(dim));
        buffer.append(", dev=");
        double stddev = this.session.getStddev(dim);
        buffer.append(DOUBLE_FORMAT.format(stddev));
        buffer.append(", err=");
        buffer.append(DOUBLE_FORMAT.format(stddev / Math.sqrt(this.count)));
        buffer.append(", interval=[");
        double[] interval = this.session.getConfidenceInterval(dim, StatisticsUtil.T90);
        buffer.append(DOUBLE_FORMAT.format(interval[0]));
        buffer.append('-');
        buffer.append(DOUBLE_FORMAT.format(interval[1]));
        buffer.append("], measures: {");
        int i = 0;
        while (i < this.count) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(this.measures[idx][i]);
            ++i;
        }
        buffer.append("}, min=");
        buffer.append(this.min[idx]);
        buffer.append(", max=");
        buffer.append(this.max[idx]);
    }

    public long getSum(int dimIndex) {
        Dim dim = DIMENSIONS[dimIndex];
        return this.session.getSum(dim);
    }

    public double getStddev(int dimIndex) {
        Dim dim = DIMENSIONS[dimIndex];
        return this.session.getStddev(dim);
    }

    public double getAverage(int dimIndex) {
        Dim dim = DIMENSIONS[dimIndex];
        return this.session.getAverage(dim);
    }

    public long getCount(int dimIndex) {
        Dim dim = DIMENSIONS[dimIndex];
        return this.session.getCount(dim);
    }
}

