/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractFwkAdminTest {
    private ServiceTracker<Object, FrameworkAdmin> fwAdminTracker;
    private File testFolder;

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                AbstractFwkAdminTest.delete(child);
                ++n2;
            }
        }
        return file.delete();
    }

    public FrameworkAdmin getEquinoxFrameworkAdmin() throws BundleException {
        String FILTER_OBJECTCLASS = "(objectClass=" + FrameworkAdmin.class.getName() + ")";
        String filterFwName = "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)";
        String filterLauncherName = "(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe)";
        String filterFwAdmin = "(&" + FILTER_OBJECTCLASS + "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe))";
        String FWK_ADMIN_EQ = "org.eclipse.equinox.frameworkadmin.equinox";
        Bundle b = Platform.getBundle((String)FWK_ADMIN_EQ);
        if (b == null) {
            throw new IllegalStateException("Bundle: " + FWK_ADMIN_EQ + " is required for this test");
        }
        b.start();
        if (this.fwAdminTracker == null) {
            try {
                Filter filter = Activator.getContext().createFilter(filterFwAdmin);
                this.fwAdminTracker = new ServiceTracker(Activator.getContext(), filter, null);
                this.fwAdminTracker.open();
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        return (FrameworkAdmin)this.fwAdminTracker.getService();
    }

    protected File getTestFolder(String name) {
        return this.getTestFolder(name, true);
    }

    protected File getTestFolder(String name, boolean clean) {
        Location instanceLocation = Platform.getInstanceLocation();
        URL url = instanceLocation != null ? instanceLocation.getURL() : null;
        this.testFolder = instanceLocation == null || !instanceLocation.isSet() || url == null ? Activator.getContext().getDataFile(name) : new File(url.getFile(), name);
        if (clean && this.testFolder.exists()) {
            AbstractFwkAdminTest.delete(this.testFolder);
        }
        this.testFolder.mkdirs();
        return this.testFolder;
    }

    @Before
    public void runTest() throws Throwable {
        if (this.testFolder != null && this.testFolder.exists()) {
            AbstractFwkAdminTest.delete(this.testFolder);
            this.testFolder = null;
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.fwAdminTracker != null) {
            this.fwAdminTracker.close();
        }
    }

    public void assertNotContent(File file, String search) {
        this.assertNotContent(null, file, search);
    }

    public void assertNotContent(String message, File file, String search) {
        if (!file.exists()) {
            Assert.fail((String)("File: " + file.toString() + " can't be found."));
        }
        try {
            String failure = null;
            StringBuilder fileContent = new StringBuilder();
            Throwable throwable = null;
            Object var7_10 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (reader.ready()) {
                    String line = reader.readLine();
                    fileContent.append(line).append('\n');
                    if (line.indexOf(search) < 0 || failure != null) continue;
                    failure = "The string: " + search + " was not expected in file '" + file.getAbsolutePath() + "'";
                }
                if (failure != null) {
                    Assert.fail((String)((String)(message != null ? message : failure) + "\n" + String.valueOf(fileContent)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException failure) {
        }
        catch (IOException e) {
            Assert.fail((String)("String: " + search + " not found in " + file.getAbsolutePath()));
        }
    }

    private String getProperty(File file, String property) {
        Properties p = new Properties();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                p.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Can't find file " + String.valueOf(file)));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading " + String.valueOf(file)));
        }
        return p.getProperty(property);
    }

    public void assertPropertyContains(File file, String property, String text) {
        int index;
        String value = this.getProperty(file, property);
        if (value == null) {
            Assert.fail((String)("property: " + property + " not found in: " + String.valueOf(file)));
        }
        if ((index = value.indexOf(text)) == -1) {
            Assert.fail((String)(text + " not found in property:" + property + " for file: " + String.valueOf(file)));
        }
    }

    public void assertNotPropertyContains(File file, String property, String text) {
        String value = this.getProperty(file, property);
        if (value == null) {
            return;
        }
        int index = value.indexOf(text);
        if (index != -1) {
            Assert.fail((String)(text + " found in property:" + property + " for file: " + String.valueOf(file)));
        }
    }

    public void assertContent(File file, String ... search) {
        this.assertContent(null, file, search);
    }

    public void assertContent(String message, File file, String ... lines) {
        if (!file.exists()) {
            Assert.fail((String)("File: " + file.toString() + " can't be found."));
        }
        int idx = 0;
        StringBuilder fileContent = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var7_10 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (reader.ready()) {
                    String line = reader.readLine();
                    fileContent.append(line).append('\n');
                    if (line.indexOf(lines[idx]) < 0 || ++idx < lines.length) continue;
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            Assert.fail((String)("String: " + lines[idx] + " not found in " + file.getAbsolutePath()));
        }
        Assert.fail((String)("String: " + lines[idx] + " not found in\n" + String.valueOf(fileContent)));
    }

    public void startSimpleConfiguratorManipulator() {
        String SIMPLECONFIGURATOR_MANIPULATOR = "org.eclipse.equinox.simpleconfigurator.manipulator";
        Bundle manipulatorBundle = Platform.getBundle((String)"org.eclipse.equinox.simpleconfigurator.manipulator");
        if (manipulatorBundle == null) {
            Assert.fail((String)"Bundle: org.eclipse.equinox.simpleconfigurator.manipulator is required for this test");
        }
        try {
            manipulatorBundle.start();
        }
        catch (BundleException e) {
            Assert.fail((String)("Exception while starting up org.eclipse.equinox.simpleconfigurator.manipulator " + e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(String message, File source, File target) {
        if (!source.exists()) {
            return;
        }
        target.getParentFile().mkdirs();
        if (source.isDirectory()) {
            File[] children;
            if (target.exists() && target.isFile()) {
                target.delete();
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            File[] fileArray = children = source.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                AbstractFwkAdminTest.copy(message, child, new File(target, child.getName()));
                ++n2;
            }
            return;
        }
        try {
            Throwable children = null;
            Object var4_14 = null;
            try {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(source));
                try {
                    try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(target));){
                        byte[] buffer = new byte[8192];
                        int bytesRead = 0;
                        while ((bytesRead = ((InputStream)input).read(buffer)) != -1) {
                            ((OutputStream)output).write(buffer, 0, bytesRead);
                        }
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable) {
                    if (children == null) {
                        children = throwable;
                    } else if (children != throwable) {
                        children.addSuppressed(throwable);
                    }
                    if (input == null) throw children;
                    ((InputStream)input).close();
                    throw children;
                }
                ((InputStream)input).close();
                return;
            }
            catch (Throwable throwable) {
                if (children == null) {
                    children = throwable;
                    throw children;
                } else {
                    if (children == throwable) throw children;
                    children.addSuppressed(throwable);
                }
                throw children;
            }
        }
        catch (IOException e) {
            Assert.fail((String)(message + ": " + String.valueOf(e)));
        }
    }

    protected File getTestData(String message, String entry) {
        URL base;
        if (entry == null) {
            Assert.fail((String)(message + " entry is null."));
        }
        if ((base = Activator.getContext().getBundle().getEntry(entry)) == null) {
            Assert.fail((String)(message + " entry not found in bundle: " + entry));
        }
        try {
            String osPath = IPath.fromOSString((String)FileLocator.toFileURL((URL)base).getPath()).toOSString();
            File result = new File(osPath);
            if (!result.getCanonicalPath().equals(result.getPath())) {
                Assert.fail((String)(message + " result path: " + result.getPath() + " does not match canonical path: " + result.getCanonicalFile().getPath()));
            }
            return result;
        }
        catch (IOException e) {
            Assert.fail((String)(message + ": " + String.valueOf(e)));
            return null;
        }
    }

    protected Manipulator getFrameworkManipulator(File configuration, File launcher) throws BundleException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configuration);
        launcherData.setLauncher(launcher);
        return manipulator;
    }

    protected void writeEclipseIni(File location, String[] lines) {
        location.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(location));){
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    bw.write(line);
                    bw.newLine();
                    ++n2;
                }
                bw.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Fail writing eclipse.ini file in " + String.valueOf(location)));
        }
    }

    protected void writeConfigIni(File location, Properties properties) {
        location.getParentFile().mkdirs();
        OutputStream out = null;
        try {
            try {
                out = new FileOutputStream(location);
                properties.store(out, "#header");
            }
            catch (IOException e) {
                Assert.fail((String)("Faile writing config.ini in" + String.valueOf(location)));
                try {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                out = null;
            }
        }
        finally {
            try {
                out.flush();
                ((FileOutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            out = null;
        }
    }

    public void assertContains(String message, BundleInfo[] bundles, URI location) {
        BundleInfo[] bundleInfoArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundle = bundleInfoArray[n2];
            if (bundle.getLocation().equals(location)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)(message + " Can't find the bundle info " + String.valueOf(location)));
    }
}

