/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.frameworkadmin.tests.SimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class Bug258370
extends FwkAdminAndSimpleConfiguratorTest {
    @Test
    public void testComma() throws FrameworkAdminRuntimeException, IOException, URISyntaxException, BundleException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(SimpleConfiguratorTest.class.getName());
        File configurationFolder = new File(installFolder, "configuration");
        String launcherName = "eclipse";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo bundle1Bi = new BundleInfo("bundle_1", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, true);
        BundleInfo bundle2Bi = new BundleInfo("bundle_2", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_2"))), 2, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(bundle1Bi);
        manipulator.getConfigData().addBundle(bundle2Bi);
        manipulator.save(false);
        File configINI = new File(configurationFolder, "config.ini");
        this.assertContent(configINI, "org.eclipse.osgi");
        this.assertContent(configINI, "bundle_1");
        this.assertContent(configINI, "bundle_2");
        this.assertContent(configINI, "start,reference");
    }
}

