/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CleanupTest
extends FwkAdminAndSimpleConfiguratorTest {
    Manipulator m = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m = this.createMinimalConfiguration(CleanupTest.class.getName());
    }

    @Test
    public void testSimpleConfiguratorRemoval() throws FrameworkAdminRuntimeException, IOException {
        BundleInfo bi;
        BundleInfo[] bis;
        BundleInfo[] bundleInfoArray = bis = this.m.getConfigData().getBundles();
        int n = bis.length;
        int n2 = 0;
        while (n2 < n) {
            bi = bundleInfoArray[n2];
            if (bi.getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bi);
            }
            ++n2;
        }
        this.m.save(false);
        Assert.assertFalse((boolean)new File(this.getConfigurationFolder(), "org.eclipse.equinox.simpleconfigurator").exists());
        Assert.assertTrue((boolean)this.getConfigurationFolder().exists());
        Assert.assertTrue((boolean)this.getConfigurationFolder().isDirectory());
        bundleInfoArray = bis = this.m.getConfigData().getBundles();
        n = bis.length;
        n2 = 0;
        while (n2 < n) {
            bi = bundleInfoArray[n2];
            if (bi.getSymbolicName().equals("org.eclipse.osgi")) {
                this.m.getConfigData().removeBundle(bi);
            }
            ++n2;
        }
        this.m.save(false);
        Assert.assertFalse((boolean)this.getConfigurationFolder().exists());
        Assert.assertFalse((boolean)new File(this.getInstallFolder(), this.getLauncherName() + ".ini").exists());
    }

    @Test
    public void testOSGiRemoval() throws FrameworkAdminRuntimeException, IOException {
        BundleInfo[] bis;
        BundleInfo[] bundleInfoArray = bis = this.m.getConfigData().getBundles();
        int n = bis.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bi = bundleInfoArray[n2];
            if (bi.getSymbolicName().equals("org.eclipse.osgi")) {
                this.m.getConfigData().removeBundle(bi);
            }
            ++n2;
        }
        this.m.save(false);
        File confFile = new File(this.getConfigurationFolder(), "org.eclipse.equinox.simpleconfigurator");
        Assert.assertTrue((boolean)confFile.exists());
        Assert.assertTrue((boolean)confFile.isDirectory());
        Assert.assertTrue((boolean)this.getConfigurationFolder().exists());
        Assert.assertTrue((boolean)this.getConfigurationFolder().isDirectory());
        this.assertNotContent(new File(this.getConfigurationFolder(), "org.eclipse.equinox.simpleconfigurator/bundles.info"), "org.eclipse.osgi");
        BundleInfo[] bundleInfoArray2 = bis = this.m.getConfigData().getBundles();
        int n3 = bis.length;
        n = 0;
        while (n < n3) {
            BundleInfo bi = bundleInfoArray2[n];
            if (bi.getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bi);
            }
            ++n;
        }
        this.m.save(false);
        Assert.assertFalse((boolean)this.getConfigurationFolder().exists());
        Assert.assertFalse((boolean)new File(this.getInstallFolder(), this.getLauncherName() + ".ini").exists());
    }

    @Test
    public void testWithMutipleBundles() throws IOException, URISyntaxException {
        BundleInfo[] bis;
        BundleInfo bi = new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, false);
        this.m.getConfigData().addBundle(bi);
        this.m.save(false);
        BundleInfo[] bundleInfoArray = bis = this.m.getConfigData().getBundles();
        int n = bis.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bi1 = bundleInfoArray[n2];
            if (bi1.getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bi1);
            }
            ++n2;
        }
        this.m.save(false);
        Assert.assertFalse((boolean)this.getBundleTxt().exists());
        this.assertContent(this.getConfigIni(), "bundle_1");
    }
}

