/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.junit.Assert;
import org.junit.Test;

public class LauncherDataTest {
    @Test
    public void testRemoveProgramArg() {
        LauncherData data = new LauncherData("equinox", "1.0", "eclipse", "1.0");
        data.setProgramArgs(new String[]{"-console", "-startup", "foo"});
        data.removeProgramArg("-startup");
        Assert.assertArrayEquals((String)"1.0", (Object[])new String[]{"-console"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "-bar"});
        data.removeProgramArg("-startup");
        Assert.assertArrayEquals((String)"2.0", (Object[])new String[]{"-console", "-bar"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-startup", "foo"});
        data.removeProgramArg("-startup");
        Assert.assertArrayEquals((String)"3.0", (Object[])new String[0], (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar"});
        data.removeProgramArg("-startup");
        Assert.assertArrayEquals((String)"4.0", (Object[])new String[]{"-console"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("-startup");
        Assert.assertArrayEquals((String)"5.0", (Object[])new String[]{"-console", "-xxx"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("foo");
        Assert.assertArrayEquals((String)"6.0", (Object[])new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("zzz");
        Assert.assertArrayEquals((String)"7.0", (Object[])new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg("foo");
        Assert.assertArrayEquals((String)"8.0", (Object[])new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, (Object[])data.getProgramArgs());
        data.setProgramArgs(null);
        data.setProgramArgs(new String[]{"-console", "-startup", "foo", "bar", "-xxx"});
        data.removeProgramArg(" ");
        Assert.assertArrayEquals((String)"9.0", (Object[])new String[]{"-console", "-startup", "foo", "bar", "-xxx"}, (Object[])data.getProgramArgs());
    }
}

