/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Test;

public class ManipulatorTests
extends AbstractFwkAdminTest {
    @Test
    public void testBug212361_osgiInBundlesList() throws Exception {
        File installFolder = Activator.getContext().getDataFile("212361");
        File configurationFolder = new File(installFolder, "configuration");
        Manipulator manipulator = this.getFrameworkManipulator(configurationFolder, new File(installFolder, "foo"));
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
        Properties configIni = new Properties();
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(configurationFolder, "config.ini")));){
            configIni.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String bundles = (String)configIni.get("osgi.bundles");
        Assert.assertEquals((long)-1L, (long)bundles.indexOf("org.eclipse.osgi"));
    }

    @Test
    public void testBug277553_installAreaFromFwJar() throws Exception {
        File folder = this.getTestFolder("installAreaFromFwJar");
        File fwJar = new File(folder, "plugins/org.eclipse.osgi.jar");
        fwJar.getParentFile().mkdirs();
        ManipulatorTests.copyStream(Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar").openStream(), true, new FileOutputStream(fwJar), true);
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", fwJar.toURI(), 0, true);
        File ini = new File(folder, "eclipse.ini");
        this.writeEclipseIni(ini, new String[]{"-foo", "bar", "-vmargs", "-Xmx256m"});
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        manipulator.getConfigData().addBundle(osgiBi);
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwJar(fwJar);
        launcherData.setLauncher(new File(folder, "eclipse"));
        manipulator.load();
        Assert.assertEquals((Object)manipulator.getLauncherData().getFwPersistentDataLocation(), (Object)new File(folder, "configuration"));
    }

    @Test
    public void testBug258126_ProgramArgs_VMArgs() throws Exception {
        File installFolder = this.getTestFolder("258126");
        File ini = new File(installFolder, "eclipse.ini");
        this.writeEclipseIni(ini, new String[]{"-foo", "bar", "-vmargs", "-Xmx256m"});
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setLauncher(new File(installFolder, "eclipse"));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertArrayEquals((Object[])launcherData.getJvmArgs(), (Object[])new String[]{"-Xmx256m"});
        Assert.assertArrayEquals((Object[])launcherData.getProgramArgs(), (Object[])new String[]{"-foo", "bar"});
        launcherData.addJvmArg("-Xms64m");
        launcherData.addProgramArg("-console");
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.save(false);
        this.assertContent(ini, "-foo", "bar", "-console", "-vmargs", "-Xmx256m", "-Xms64m");
    }
}

