/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class NoConfigurationValueInEclipseIni
extends FwkAdminAndSimpleConfiguratorTest {
    @Test
    public void testAbsenceOfConfigurationInEclipseINI() throws Exception {
        this.createMinimalConfiguration(NoConfigurationValueInEclipseIni.class.getName());
        File launcherIni = new File(this.getInstallFolder(), this.getLauncherName() + ".ini");
        this.assertNotContent(launcherIni, "-configuration");
    }

    @Test
    public void testPresenceOfConfigurationInEclipseINI() throws FrameworkAdminRuntimeException, IOException, BundleException, URISyntaxException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile("bis" + NoConfigurationValueInEclipseIni.class.getName());
        File configurationFolder = new File(installFolder, "config2");
        String launcherName = "eclipse";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        try {
            manipulator.save(false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        File launcherIni = new File(installFolder, launcherName + ".ini");
        this.assertContent(launcherIni, "-configuration");
    }
}

