/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class OSGiVersionChange
extends FwkAdminAndSimpleConfiguratorTest {
    private Manipulator defaultManipulator = null;
    private final String workArea = OSGiVersionChange.class.getName();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.defaultManipulator = this.createMinimalConfiguration(this.workArea);
    }

    @Test
    public void testRemovalUsingSameManipulator() throws IllegalStateException, FrameworkAdminRuntimeException, IOException {
        BundleInfo[] infos = this.defaultManipulator.getConfigData().getBundles();
        BundleInfo osgi = null;
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if ("org.eclipse.osgi".equals(info.getSymbolicName())) {
                osgi = info;
                break;
            }
            ++n2;
        }
        Assert.assertEquals((Object)true, (Object)this.defaultManipulator.getConfigData().removeBundle(osgi));
        this.defaultManipulator.save(false);
        this.assertNotContent(this.getBundleTxt(), "org.eclipse.osgi");
        this.assertNotPropertyContains(this.getConfigIni(), "osgi.bundles", "org.eclipse.osgi");
    }

    @Test
    public void testRemovalUsingOtherManipulator() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        Manipulator newManipulator = this.getNewManipulator(this.workArea);
        BundleInfo[] infos = newManipulator.getConfigData().getBundles();
        BundleInfo osgi = null;
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if ("org.eclipse.osgi".equals(info.getSymbolicName())) {
                osgi = info;
                break;
            }
            ++n2;
        }
        newManipulator.getConfigData().removeBundle(osgi);
        newManipulator.save(false);
        this.assertNotContent(this.getBundleTxt(), "org.eclipse.osgi");
        this.assertNotPropertyContains(this.getConfigIni(), "osgi.bundles", "org.eclipse.osgi");
    }

    @Test
    public void testAdditionUsingOtherManipulator() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        BundleInfo[] infos = this.defaultManipulator.getConfigData().getBundles();
        BundleInfo osgi = null;
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if ("org.eclipse.osgi".equals(info.getSymbolicName())) {
                osgi = info;
                break;
            }
            ++n2;
        }
        Assert.assertEquals((Object)true, (Object)this.defaultManipulator.getConfigData().removeBundle(osgi));
        this.defaultManipulator.save(false);
        Manipulator newManipulator = this.getNewManipulator(this.workArea);
        newManipulator.getConfigData().addBundle(osgi);
        newManipulator.save(false);
        this.assertContent(this.getBundleTxt(), "org.eclipse.osgi");
        this.assertNotPropertyContains(this.getConfigIni(), "osgi.bundles", "org.eclipse.osgi");
    }

    @Test
    public void testChangeVersion() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, URISyntaxException {
        BundleInfo[] infos = this.defaultManipulator.getConfigData().getBundles();
        BundleInfo osgi = null;
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if ("org.eclipse.osgi".equals(info.getSymbolicName())) {
                osgi = info;
                break;
            }
            ++n2;
        }
        this.defaultManipulator.getConfigData().removeBundle(osgi);
        this.defaultManipulator.save(false);
        String FILENAME = "org.eclipse.osgi_3.4.0.jar";
        String VERSION = "3.4.0.v20071105";
        BundleInfo newOSGi = new BundleInfo("org.eclipse.osgi", "3.4.0.v20071105", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi_3.4.0.jar"))), 0, true);
        this.defaultManipulator.getConfigData().addBundle(newOSGi);
        this.defaultManipulator.save(false);
        this.assertContent(this.getBundleTxt(), "3.4.0.v20071105");
        this.assertContent(this.getConfigIni(), "org.eclipse.osgi_3.4.0.jar");
    }

    @Test
    public void testReadConfigWithoutOSGi() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        BundleInfo[] infos = this.defaultManipulator.getConfigData().getBundles();
        BundleInfo osgi = null;
        BundleInfo[] bundleInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            if ("org.eclipse.osgi".equals(info.getSymbolicName())) {
                osgi = info;
                break;
            }
            ++n2;
        }
        this.defaultManipulator.getConfigData().removeBundle(osgi);
        this.defaultManipulator.save(false);
        this.assertNotContent(this.getBundleTxt(), "org.eclipse.osgi");
        this.assertNotPropertyContains(this.getConfigIni(), "osgi.bundles", "org.eclipse.osgi");
        Manipulator newManipulator = this.getNewManipulator(this.workArea);
        Assert.assertEquals((long)1L, (long)newManipulator.getConfigData().getBundles().length);
    }
}

