/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.internal.frameworkadmin.equinox.ParserUtils;
import org.junit.Assert;
import org.junit.Test;

public class ParserUtilsTest
extends AbstractFwkAdminTest {
    @Test
    public void testGetValueForArgument() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-foo");
        args.add("bar");
        Assert.assertEquals((Object)"bar", (Object)ParserUtils.getValueForArgument((String)"-foo", args));
        args.set(1, "-bar");
        Assert.assertEquals(null, (Object)ParserUtils.getValueForArgument((String)"-foo", args));
    }

    @Test
    public void testRemoveArgument() throws Exception {
        Object[] args = new String[]{"-bar", "-foo", "-other"};
        ParserUtils.removeArgument((String)"-foo", Arrays.asList(args));
        Object[] objectArray = new String[3];
        objectArray[0] = "-bar";
        objectArray[2] = "-other";
        Assert.assertArrayEquals((Object[])args, (Object[])objectArray);
        args = new String[]{"-bar", "-foo", "other"};
        ParserUtils.removeArgument((String)"-foo", Arrays.asList(args));
        Object[] objectArray2 = new String[3];
        objectArray2[0] = "-bar";
        Assert.assertArrayEquals((Object[])args, (Object[])objectArray2);
        args = new String[]{"-bar", "-foo", "s-pecial"};
        ParserUtils.removeArgument((String)"-foo", Arrays.asList(args));
        Object[] objectArray3 = new String[3];
        objectArray3[0] = "-bar";
        Assert.assertArrayEquals((Object[])args, (Object[])objectArray3);
    }

    @Test
    public void testSetValueForArgument() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        ParserUtils.setValueForArgument((String)"-foo", (String)"bar", args);
        Assert.assertEquals((long)2L, (long)args.size());
        Assert.assertEquals(args.get(0), (Object)"-foo");
        Assert.assertEquals(args.get(1), (Object)"bar");
        args.add("-other");
        args.set(1, "s-pecial");
        ParserUtils.setValueForArgument((String)"-foo", (String)"bas", args);
        Assert.assertEquals((long)3L, (long)args.size());
        Assert.assertEquals(args.get(0), (Object)"-foo");
        Assert.assertEquals(args.get(1), (Object)"bas");
        Assert.assertEquals(args.get(2), (Object)"-other");
        args.remove(1);
        ParserUtils.setValueForArgument((String)"-foo", (String)"bas", args);
        Assert.assertEquals((long)3L, (long)args.size());
        Assert.assertEquals(args.get(0), (Object)"-foo");
        Assert.assertEquals(args.get(1), (Object)"bas");
        Assert.assertEquals(args.get(2), (Object)"-other");
    }

    @Test
    public void testFromOSGiJarToOSGiInstallArea() {
        String path = "";
        File result = ParserUtils.fromOSGiJarToOSGiInstallArea((String)path);
        Assert.assertNotNull((String)"1.0", (Object)result);
        path = "osgi.jar";
        result = ParserUtils.fromOSGiJarToOSGiInstallArea((String)path);
        Assert.assertNotNull((String)"1.0", (Object)result);
        Assert.assertEquals((String)"1.1", (Object)"", (Object)result.toString());
    }
}

