/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class ReaderTest4
extends AbstractFwkAdminTest {
    private File installFolder = null;
    private File configurationFolder = null;
    private final String launcherName = "eclipse";

    @Before
    public void setUp() throws Exception {
        this.startSimpleConfiguratorManipulator();
        this.installFolder = Activator.getContext().getDataFile(ReaderTest4.class.getName());
        this.configurationFolder = new File(this.installFolder, "conf");
        this.writeEclipseIni(new File(this.installFolder, "eclipse.ini"), new String[]{"-install", this.installFolder.getAbsolutePath(), "-configuration", URIUtil.toUnencodedString((URI)URIUtil.makeRelative((URI)this.configurationFolder.toURI(), (URI)this.installFolder.toURI()))});
        Properties properties = new Properties();
        properties.setProperty("foo", "bar");
        this.writeConfigIni(new File(this.configurationFolder, "config.ini"), properties);
    }

    @Test
    public void testConfigContent() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setLauncher(new File(this.installFolder, "eclipse"));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)new File(this.installFolder, "conf"), (Object)manipulator.getLauncherData().getFwConfigLocation());
        Assert.assertEquals((Object)"bar", (Object)manipulator.getConfigData().getProperty("foo"));
    }
}

