/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Test;

public class RelativePathTest
extends FwkAdminAndSimpleConfiguratorTest {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    @Test
    public void testRelativePaths() throws Exception {
        File installFolder = Activator.getContext().getDataFile(RelativePathTest.class.getName());
        File osgiJar = new File(installFolder, "plugins/org.eclipse.osgi.jar");
        osgiJar.getParentFile().mkdirs();
        File scJar = new File(installFolder, "plugins/org.eclipse.equinox.simpleconfigurator.jar");
        RelativePathTest.copyStream(Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar").openStream(), true, new FileOutputStream(osgiJar), true);
        RelativePathTest.copyStream(Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar").openStream(), true, new FileOutputStream(scJar), true);
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File configurationFolder = new File(installFolder, "configuration");
        String launcherName = "eclipse";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", osgiJar.toURI(), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", scJar.toURI(), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
        this.assertNotContent(new File(configurationFolder, "config.ini"), installFolder.getAbsolutePath());
        this.assertNotContent(new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info"), installFolder.getAbsolutePath());
        this.assertContent(new File(configurationFolder, "config.ini"), ":org.eclipse.equinox.simpleconfigurator.jar");
        this.assertContent(new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info"), "file:plugins/org.eclipse.equinox.simpleconfigurator.jar");
        this.assertContent(new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info"), "file:plugins/org.eclipse.osgi.jar");
        BundleInfo bi = new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, false);
        manipulator.getConfigData().addBundle(bi);
        manipulator.save(false);
        Manipulator newManipulator = fwkAdmin.getManipulator();
        LauncherData newLauncherData = newManipulator.getLauncherData();
        newLauncherData.setFwConfigLocation(configurationFolder);
        newLauncherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMakeRelative_NonWindows() throws MalformedURLException {
        if (WINDOWS) {
            return;
        }
        URL base = new URL("file:/eclipse/");
        String[][] data = new String[][]{{"file:/home/eclipse/foo.jar", "file:../home/eclipse/foo.jar"}, {"file:///home/eclipse/foo.jar", "file:../home/eclipse/foo.jar"}};
        int i = 0;
        while (i < data.length) {
            Assert.assertEquals((String)("1." + i), (Object)data[i][1], (Object)EquinoxManipulatorImpl.makeRelative((String)data[i][0], (URL)base));
            ++i;
        }
    }

    @Test
    public void testMakeRelative_Windows() throws MalformedURLException {
        if (!WINDOWS) {
            return;
        }
        URL base = new URL("file:/c:/a/eclipse/");
        String[][] data = new String[][]{{"file:c:/b/shared/plugins/bar.jar", "file:../../b/shared/plugins/bar.jar"}, {"file:d:/b/shared/plugins/bar.jar", "file:d:/b/shared/plugins/bar.jar"}, {"file:/c:/a/eclipse/plugins/bar.jar", "file:plugins/bar.jar"}, {"file:c:/a/eclipse/plugins/bar.jar", "file:plugins/bar.jar"}, {"file:/c:/a/shared/plugins/bar.jar", "file:../shared/plugins/bar.jar"}, {"file:/d:/a/eclipse/plugins/bar.jar", "file:/d:/a/eclipse/plugins/bar.jar"}, {"file:/c:/x/eclipse/plugins/bar.jar", "file:../../x/eclipse/plugins/bar.jar"}};
        int i = 0;
        while (i < data.length) {
            Assert.assertEquals((String)("2." + i), (Object)data[i][1], (Object)EquinoxManipulatorImpl.makeRelative((String)data[i][0], (URL)base));
            ++i;
        }
    }
}

