/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class RemovingABundle
extends FwkAdminAndSimpleConfiguratorTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Manipulator manipulator = this.createMinimalConfiguration(RemovingABundle.class.getName());
        manipulator.getConfigData().addBundle(new BundleInfo("bundle_1", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 4, false));
        manipulator.save(false);
        File fooINI = new File(this.getInstallFolder(), this.getLauncherName() + ".ini");
        Assert.assertTrue((boolean)fooINI.exists());
        this.assertContent(this.getBundleTxt(), "bundle_1");
    }

    @Test
    public void testRemoveBundleWithoutURL() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        Manipulator m2 = this.getEquinoxFrameworkAdmin().getManipulator();
        LauncherData launcherData2 = m2.getLauncherData();
        launcherData2.setFwConfigLocation(this.getConfigurationFolder());
        launcherData2.setLauncher(new File(this.getInstallFolder(), "eclipse"));
        try {
            m2.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BundleInfo info = new BundleInfo("bundle_1", "1.0.0", null, 0, false);
        m2.getConfigData().removeBundle(info);
        m2.save(false);
        this.assertNotContent(this.getBundleTxt(), "bundle_1");
    }
}

