/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class RemovingAllBundles
extends AbstractFwkAdminTest {
    @Test
    public void testConfigFiles() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException, URISyntaxException {
        BundleInfo[] infos;
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(RemovingAllBundles.class.getName());
        File configurationFolder = new File(installFolder, "configuration");
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(configurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
        File fooINI = new File(installFolder, "foo.ini");
        Assert.assertTrue((boolean)fooINI.exists());
        Manipulator m2 = fwkAdmin.getManipulator();
        LauncherData launcherData2 = m2.getLauncherData();
        launcherData2.setFwConfigLocation(configurationFolder);
        launcherData2.setLauncher(new File(installFolder, launcherName));
        try {
            m2.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        BundleInfo[] bundleInfoArray = infos = m2.getConfigData().getBundles();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo info = bundleInfoArray[n2];
            m2.getConfigData().removeBundle(info);
            ++n2;
        }
        m2.save(false);
        Assert.assertFalse((boolean)new File(String.valueOf(configurationFolder) + "/org.eclipse.equinox.simpleconfigurator", "bundles.info").exists());
    }
}

