/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.AbstractFwkAdminTest;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.osgi.framework.BundleException;

public class SharedConfigurationTest
extends AbstractFwkAdminTest {
    private static final String BASE_CONFIG_INI_TIMESTAMP = ".baseConfigIniTimestamp";
    @Rule
    public TestName name = new TestName();

    @Test
    public void testDefaultConfiguration() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(this.name.getMethodName());
        File defaultConfigurationFolder = new File(installFolder, "configuration");
        defaultConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/config.ini"), new File(defaultConfigurationFolder, "config.ini"));
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(defaultConfigurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"false", (Object)manipulator.getConfigData().getProperty("config.shared"));
        Assert.assertEquals((Object)"true", (Object)manipulator.getConfigData().getProperty("from.parent"));
    }

    @Test
    public void testSharedConfiguration() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(this.name.getMethodName());
        File defaultConfigurationFolder = new File(installFolder, "configuration");
        defaultConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/config.ini"), new File(defaultConfigurationFolder, "config.ini"));
        File userConfigurationFolder = new File(installFolder, "user/configuration");
        userConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/user-config.ini"), new File(userConfigurationFolder, "config.ini"));
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(userConfigurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"true", (Object)manipulator.getConfigData().getProperty("config.shared"));
        Assert.assertEquals((Object)"true", (Object)manipulator.getConfigData().getProperty("from.parent"));
    }

    @Test
    public void testNotSharedConfiguration() throws IllegalStateException, FrameworkAdminRuntimeException, IOException, BundleException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(this.name.getMethodName());
        File defaultConfigurationFolder = new File(installFolder, "configuration");
        defaultConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/config.ini"), new File(defaultConfigurationFolder, "config.ini"));
        File userConfigurationFolder = new File(installFolder, "user/configuration");
        userConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/user-noshare-config.ini"), new File(userConfigurationFolder, "config.ini"));
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(userConfigurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"false", (Object)manipulator.getConfigData().getProperty("config.shared"));
        Assert.assertEquals(null, (Object)manipulator.getConfigData().getProperty("from.parent"));
    }

    @Test
    public void testConfigIniTimestamp() throws BundleException, FrameworkAdminRuntimeException, IOException, URISyntaxException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(this.name.getMethodName());
        File defaultConfigurationFolder = new File(installFolder, "configuration");
        defaultConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/config.ini"), new File(defaultConfigurationFolder, "config.ini"));
        File userConfigurationFolder = new File(installFolder, "user/configuration");
        userConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/user-config.ini"), new File(userConfigurationFolder, "config.ini"));
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(userConfigurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        BundleInfo osgiBi = new BundleInfo("org.eclipse.osgi", "3.3.1", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.osgi.jar"))), 0, true);
        BundleInfo configuratorBi = new BundleInfo("org.eclipse.equinox.simpleconfigurator", "1.0.0", URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true);
        manipulator.getConfigData().addBundle(osgiBi);
        manipulator.getConfigData().addBundle(configuratorBi);
        manipulator.save(false);
        File baseTimestamp = new File(userConfigurationFolder, BASE_CONFIG_INI_TIMESTAMP);
        Assert.assertTrue((boolean)baseTimestamp.exists());
        Assert.assertTrue((boolean)baseTimestamp.isFile());
        this.assertContent(baseTimestamp, Long.toString(new File(defaultConfigurationFolder, "config.ini").lastModified()));
    }

    @Test
    public void testConfigurationIgnoredWhenChanged() throws BundleException, FrameworkAdminRuntimeException, IOException {
        this.startSimpleConfiguratorManipulator();
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator manipulator = fwkAdmin.getManipulator();
        File installFolder = Activator.getContext().getDataFile(this.name.getMethodName());
        File defaultConfigurationFolder = new File(installFolder, "configuration");
        defaultConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/ignoreUserConfig/config.ini"), new File(defaultConfigurationFolder, "config.ini"));
        File userConfigurationFolder = new File(installFolder, "user/configuration");
        userConfigurationFolder.mkdirs();
        SharedConfigurationTest.copy("creating shared config.ini", this.getTestData("", "dataFile/sharedconfiguration/ignoreUserConfig/user-config.ini"), new File(userConfigurationFolder, "config.ini"));
        Properties p = new Properties();
        p.setProperty("configIniTimestamp", Long.toString(new File(defaultConfigurationFolder, "config.ini").lastModified() - 10L));
        this.saveProperties(new File(userConfigurationFolder, BASE_CONFIG_INI_TIMESTAMP), p);
        String launcherName = "foo";
        LauncherData launcherData = manipulator.getLauncherData();
        launcherData.setFwConfigLocation(userConfigurationFolder);
        launcherData.setLauncher(new File(installFolder, launcherName));
        try {
            manipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNull((Object)manipulator.getConfigData().getProperty("userKey"));
        Assert.assertEquals((Object)"sharedValue", (Object)manipulator.getConfigData().getProperty("sharedKey"));
    }

    private void saveProperties(File outputFile, Properties configProps) throws IOException {
        String header = "This configuration file was written by: " + this.getClass().getName();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            configProps.store(out, header);
        }
        finally {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

