/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.frameworkadmin.tests.Activator;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class SimpleConfiguratorComingAndGoing
extends FwkAdminAndSimpleConfiguratorTest {
    Manipulator m = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m = this.createMinimalConfiguration(SimpleConfiguratorComingAndGoing.class.getName());
    }

    @Test
    public void testWithMutipleBundles() throws IOException, BundleException, URISyntaxException {
        BundleInfo[] bis;
        BundleInfo bi = new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/bundle_1"))), 2, false);
        this.m.getConfigData().addBundle(bi);
        this.m.save(false);
        BundleInfo[] bundleInfoArray = bis = this.m.getConfigData().getBundles();
        int n = bis.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bi1 = bundleInfoArray[n2];
            if (bi1.getSymbolicName().equals("org.eclipse.equinox.simpleconfigurator")) {
                this.m.getConfigData().removeBundle(bi1);
            }
            ++n2;
        }
        this.m.save(false);
        Assert.assertFalse((boolean)this.getBundleTxt().exists());
        this.assertContent(this.getConfigIni(), "bundle_1");
        this.assertContent(this.getConfigIni(), "org.eclipse.osgi");
        FrameworkAdmin fwkAdmin = this.getEquinoxFrameworkAdmin();
        Manipulator newManipulator = fwkAdmin.getManipulator();
        LauncherData launcherData = newManipulator.getLauncherData();
        launcherData.setFwConfigLocation(this.getConfigurationFolder());
        launcherData.setLauncher(new File(this.getInstallFolder(), this.getLauncherName()));
        try {
            newManipulator.load();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        newManipulator.getConfigData().addBundle(new BundleInfo(URIUtil.toURI((URL)FileLocator.resolve((URL)Activator.getContext().getBundle().getEntry("dataFile/org.eclipse.equinox.simpleconfigurator.jar"))), 1, true));
        newManipulator.save(false);
        this.assertContent(this.getBundleTxt(), "org.eclipse.osgi");
        this.assertContent(this.getBundleTxt(), "bundle_1");
        this.assertContent(this.getBundleTxt(), "org.eclipse.equinox.simpleconfigurator");
    }
}

