/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.frameworkadmin.tests;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.tests.FwkAdminAndSimpleConfiguratorTest;
import org.eclipse.equinox.frameworkadmin.tests.TestEclipseDataArea;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVMArg
extends FwkAdminAndSimpleConfiguratorTest {
    private Manipulator m;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m = this.createMinimalConfiguration(TestEclipseDataArea.class.getName());
    }

    @Test
    public void testVMInsideInstall() throws FrameworkAdminRuntimeException, IOException {
        File jreLocation = new File(this.m.getLauncherData().getLauncher().getParentFile(), "jre");
        this.m.getLauncherData().setJvm(jreLocation);
        this.m.save(false);
        this.assertNotContent(this.getLauncherConfigFile(), jreLocation.getAbsolutePath());
        this.assertContent(this.getLauncherConfigFile(), "jre");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "jre");
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "file:");
        this.m.load();
        Assert.assertEquals((Object)jreLocation, (Object)this.m.getLauncherData().getJvm());
        this.m.getLauncherData().setJvm(null);
        this.m.save(false);
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "jre");
    }

    @Test
    public void testVMOutsideInstall() throws FrameworkAdminRuntimeException, IOException {
        File jreLocation = new File(this.m.getLauncherData().getLauncher().getParentFile(), "../../jre").getCanonicalFile();
        this.m.getLauncherData().setJvm(jreLocation);
        this.m.save(false);
        this.assertContent(this.getLauncherConfigFile(), jreLocation.getAbsolutePath().replace('\\', '/'));
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "jre");
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "file:");
        this.m.load();
        Assert.assertEquals((Object)jreLocation, (Object)this.m.getLauncherData().getJvm());
    }

    @Test
    public void test269502() throws FrameworkAdminRuntimeException, IOException {
        String winPath = "c:/ibm5sr3/bin";
        String linuxPath = "/Users/Pascal/ibm5sr3/bin";
        String chosenPath = Platform.getOS().equals("win32") ? winPath : linuxPath;
        File jreLocation = new File(chosenPath);
        this.m.getLauncherData().setJvm(jreLocation);
        this.m.save(false);
        this.assertContent(this.getLauncherConfigFile(), chosenPath);
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), "-vm");
        this.assertContent(this.m.getLauncherData().getLauncherConfigLocation(), chosenPath);
        this.assertNotContent(this.m.getLauncherData().getLauncherConfigLocation(), "file:");
        this.m.load();
        Assert.assertEquals((Object)jreLocation, (Object)this.m.getLauncherData().getJvm());
    }

    @Test
    public void testGH361() throws FrameworkAdminRuntimeException, IOException {
        String arg1 = "#mycommentline1";
        String arg2 = "!noncommentline2";
        String arg3 = " #noncommentline3";
        String arg4 = "#mycommentline4";
        this.m.getLauncherData().addProgramArg(arg1);
        this.m.getLauncherData().addProgramArg(arg2);
        this.m.getLauncherData().addProgramArg(arg3);
        this.m.getLauncherData().addProgramArg(arg4);
        this.m.save(false);
        this.m.load();
        String[] programArgs = this.m.getLauncherData().getProgramArgs();
        Assert.assertFalse((boolean)Arrays.asList(programArgs).contains(arg1));
        Assert.assertTrue((boolean)Arrays.asList(programArgs).contains(arg2));
        Assert.assertTrue((boolean)Arrays.asList(programArgs).contains(arg3));
        Assert.assertFalse((boolean)Arrays.asList(programArgs).contains(arg4));
    }

    @Test
    public void test282303() throws FrameworkAdminRuntimeException, IOException {
        this.assertNotContent(this.getLauncherConfigFile(), "-vm");
        this.assertNotContent(this.getLauncherConfigFile(), "../mylocation");
        this.assertNotContent(this.getLauncherConfigFile(), "-otherarg");
        this.m.getLauncherData().addProgramArg("-vm");
        this.m.getLauncherData().addProgramArg("../mylocation");
        this.m.getLauncherData().addProgramArg("-otherarg");
        this.m.getLauncherData().setJvm(new File("../mylocation"));
        this.m.save(false);
        this.m.load();
        String[] args = this.m.getLauncherData().getProgramArgs();
        boolean found = false;
        int i = 0;
        while (i < args.length) {
            if ("-vm".equals(args[i]) && i != args.length - 1 && "../mylocation".equals(args[++i])) {
                found = true;
                break;
            }
            ++i;
        }
        Assert.assertTrue((String)"Can't find vm argument.", (boolean)found);
    }
}

