/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.frameworkadmin.equinox;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.junit.Assert;
import org.junit.Test;

public class EquinoxManipulatorImplTest {
    @Test
    public void testToFile() throws MalformedURLException {
        String filename = "test.txt";
        String unixUrl = "file:/program files/eclipse/";
        String expectedUnixFolder = "/program files/eclipse";
        String expectedUnixFile = expectedUnixFolder + "/" + filename;
        Assert.assertEquals((Object)new File(expectedUnixFolder), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(unixUrl)));
        Assert.assertEquals((Object)new File(expectedUnixFile), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(unixUrl + filename)));
        String windowsUrl = "file:/C:/Program Files/eclipse/";
        String expectedWindowsFolder = "C:\\Program Files\\eclipse";
        String expectedWindowsFile = expectedWindowsFolder + "\\" + filename;
        Assert.assertEquals((Object)new File(expectedWindowsFolder), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(windowsUrl)));
        Assert.assertEquals((Object)new File(expectedWindowsFile), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(windowsUrl + filename)));
        String uncUrl = "file://server/share/folder/";
        String expectedUncFolder = "//server/share/folder";
        String expectedUncFile = expectedUncFolder + "/" + filename;
        Assert.assertEquals((Object)new File(expectedUncFolder), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(uncUrl)));
        Assert.assertEquals((Object)new File(expectedUncFile), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(uncUrl + filename)));
        String notFileUrl = "http://example.com/path/to/folder/";
        String expectedOtherFolder = "/path/to/folder";
        String expectedOtherFile = expectedOtherFolder + "/" + filename;
        Assert.assertEquals((Object)new File(expectedOtherFolder), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(notFileUrl)));
        Assert.assertEquals((Object)new File(expectedOtherFile), (Object)EquinoxManipulatorImpl.toFile((URL)new URL(notFileUrl + filename)));
    }
}

