/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.tests;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class BundleInstaller {
    private final BundleContext context;
    private final String rootLocation;
    private Map<String, Bundle> bundles = new HashMap<String, Bundle>();
    private final ServiceTracker<?, URLConverter> converter;

    public BundleInstaller(String bundlesRoot, BundleContext context) throws InvalidSyntaxException {
        this.context = context;
        this.rootLocation = bundlesRoot;
        this.converter = new ServiceTracker(context, context.createFilter("(&(objectClass=" + URLConverter.class.getName() + ")(protocol=bundleentry))"), null);
        this.converter.open();
    }

    public synchronized Bundle installBundle(String name) throws BundleException {
        return this.installBundle(name, true);
    }

    public synchronized Bundle installBundle(String name, boolean track) throws BundleException {
        if (this.bundles == null && track) {
            return null;
        }
        String location = this.getBundleLocation(name);
        Bundle bundle = this.context.installBundle(location);
        if (track) {
            this.bundles.put(name, bundle);
        }
        return bundle;
    }

    public String getBundleLocation(String name) throws BundleException {
        String bundleFileName = this.rootLocation + "/" + name;
        URL bundleURL = this.context.getBundle().getEntry(bundleFileName);
        if (bundleURL == null) {
            bundleURL = this.context.getBundle().getEntry(bundleFileName + ".jar");
        }
        if (bundleURL == null) {
            throw new BundleException("Could not find bundle to install at: " + name);
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        Object location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + (String)location;
        }
        return location;
    }

    public synchronized Bundle updateBundle(String fromName, String toName) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle fromBundle = this.bundles.get(fromName);
        if (fromBundle == null) {
            throw new BundleException("The bundle to update does not exist!! " + fromName);
        }
        String bundleFileName = this.rootLocation + "/" + toName;
        URL bundleURL = this.context.getBundle().getEntry(bundleFileName);
        if (bundleURL == null) {
            bundleURL = this.context.getBundle().getEntry(bundleFileName + ".jar");
        }
        try {
            bundleURL = ((URLConverter)this.converter.getService()).resolve(bundleURL);
        }
        catch (IOException e) {
            throw new BundleException("Converter error", (Throwable)e);
        }
        Object location = bundleURL.toExternalForm();
        if ("file".equals(bundleURL.getProtocol())) {
            location = "reference:" + (String)location;
        }
        try {
            fromBundle.update(new URL((String)location).openStream());
        }
        catch (Exception e) {
            throw new BundleException("Errors when updating bundle " + String.valueOf(fromBundle), (Throwable)e);
        }
        this.bundles.remove(fromName);
        this.bundles.put(toName, fromBundle);
        return fromBundle;
    }

    public synchronized Bundle uninstallBundle(String name) throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle bundle = this.bundles.remove(name);
        if (bundle == null) {
            return null;
        }
        bundle.uninstall();
        return bundle;
    }

    public synchronized void uninstallBundle(Bundle b) throws BundleException {
        if (this.bundles == null) {
            return;
        }
        if (this.bundles.containsValue(b)) {
            for (Map.Entry<String, Bundle> entry : this.bundles.entrySet()) {
                if (!entry.getValue().equals(b)) continue;
                this.bundles.remove(entry.getKey());
                break;
            }
        }
        b.uninstall();
    }

    public synchronized Bundle[] uninstallAllBundles() throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        ArrayList<Bundle> result = new ArrayList<Bundle>(this.bundles.size());
        for (Bundle bundle : this.bundles.values()) {
            try {
                bundle.uninstall();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            result.add(bundle);
        }
        this.bundles.clear();
        return result.toArray(new Bundle[result.size()]);
    }

    public synchronized Bundle getBundle(String name) {
        if (this.bundles == null) {
            return null;
        }
        return this.bundles.get(name);
    }

    public synchronized Bundle[] shutdown() throws BundleException {
        if (this.bundles == null) {
            return null;
        }
        Bundle[] result = this.uninstallAllBundles();
        this.converter.close();
        this.bundles = null;
        return result;
    }
}

