/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.eclipse.equinox.ds.tests.DSTestsActivator;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

public class LazyServiceComponentActivationDeadLockTest {
    @Test
    public void testServiceFactoryDeadLock() throws Exception {
        class Service2 {
            Service2() {
            }
        }
        CountDownLatch l1 = new CountDownLatch(1);
        CountDownLatch l2 = new CountDownLatch(1);
        BundleContext ctx = DSTestsActivator.getContext();
        class Service1 {
            Service1() {
            }
        }
        class SimpleServiceFactory<T>
        implements ServiceFactory<T> {
            private final BiFunction<Bundle, ServiceRegistration<T>, T> factory;

            SimpleServiceFactory(BiFunction<Bundle, ServiceRegistration<T>, T> factory) {
                this.factory = factory;
            }

            public T getService(Bundle bundle, ServiceRegistration<T> registration) {
                return this.factory.apply(bundle, registration);
            }

            public void ungetService(Bundle bundle, ServiceRegistration<T> registration, T service) {
            }
        }
        SimpleServiceFactory<Service1> factory1 = new SimpleServiceFactory<Service1>((bundle, registration) -> {
            this.countDownAndAwaitOther(l1, l2);
            ctx.getService(ctx.getServiceReference(Service2.class));
            return new Service1();
        });
        SimpleServiceFactory<Service2> factory2 = new SimpleServiceFactory<Service2>((bundle, registration) -> {
            this.countDownAndAwaitOther(l2, l1);
            ctx.getService(ctx.getServiceReference(Service1.class));
            return new Service2();
        });
        ctx.registerService(Service1.class, factory1, null);
        ctx.registerService(Service2.class, factory2, null);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Future<Service1> service1 = executor.submit(() -> (Service1)ctx.getService(ctx.getServiceReference(Service1.class)));
            Future<Service2> service2 = executor.submit(() -> (Service2)ctx.getService(ctx.getServiceReference(Service2.class)));
            Service1 s1 = service1.get(5L, TimeUnit.SECONDS);
            Service2 s2 = service2.get(5L, TimeUnit.SECONDS);
            if (s1 != null && s2 != null) {
                Assert.fail((String)"At least one dead-locked component should be null");
            }
        }
        finally {
            executor.shutdown();
        }
    }

    void countDownAndAwaitOther(CountDownLatch l1, CountDownLatch l2) {
        l1.countDown();
        try {
            l2.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testLateBindingInSameBundleDeadLock() throws Exception {
        BundleContext ctx = DSTestsActivator.getContext();
        ServiceReference reference = ctx.getServiceReference(Component1.class);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<Component1> service = executor.submit(() -> (Component1)ctx.getService(reference));
            Component1 c1 = service.get(5L, TimeUnit.SECONDS);
            if (c1 != null) {
                Assert.assertTrue((boolean)c1.a.c3s.isEmpty());
                Assert.assertNotNull((Object)c1.b.b);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Component(service={Component1.class})
    public static class Component1 {
        @Reference
        Component2 a;
        @Reference
        Component4 b;
    }

    @Component(service={Component2.class})
    public static class Component2 {
        @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
        final List<Component3> c3s = new CopyOnWriteArrayList<Component3>();
    }

    @Component(service={Component3.class})
    public static class Component3 {
        @Reference
        Component2 a;
        @Reference
        Component5 b;
    }

    @Component(service={Component4.class})
    public static class Component4 {
        @Reference
        Component5 b;
        @Reference
        AwaitComponent5Activation a;

        @Component(service={AwaitComponent5Activation.class})
        public static class AwaitComponent5Activation {
            @Activate
            public void activated() throws InterruptedException {
                Component5.ACTIVATION_STARTED.await();
            }
        }
    }

    @Component(service={Component5.class})
    public static class Component5 {
        @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
        final List<Component1> c1s = new ArrayList<Component1>();
        @Reference
        ActivationStartedIndicator a;
        static final CountDownLatch ACTIVATION_STARTED = new CountDownLatch(1);

        @Component(service={ActivationStartedIndicator.class})
        public static class ActivationStartedIndicator {
            @Activate
            public void activated() {
                ACTIVATION_STARTED.countDown();
            }
        }
    }
}

