/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.TestHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.internal.preferences.TestScope;
import org.eclipse.core.tests.internal.preferences.TestScope2;
import org.eclipse.core.tests.runtime.RuntimeTestsPlugin;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferencesTest {
    public String TEST_NODE_PATH = "test.node.path";
    public String TEST_PREF_KEY = "test.pref.key";

    @AfterEach
    public void tearDown() throws Exception {
        IEclipsePreferences node = this.getScopeRoot();
        node.removeNode();
    }

    private IEclipsePreferences getScopeRoot() {
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("test");
    }

    @Test
    public void testRemove() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        String value = "hello";
        String defaultValue = null;
        Assert.assertEquals((String)"1.1", defaultValue, (Object)prefs.get("key1", defaultValue));
        prefs.put("key1", "hello");
        Assert.assertEquals((String)"1.2", (Object)"hello", (Object)prefs.get("key1", defaultValue));
        prefs.removeNode();
        Assert.assertFalse((String)"2.5", (boolean)prefs.nodeExists(""));
        Assert.assertThrows(IllegalStateException.class, () -> prefs.remove("key1"));
    }

    @Test
    public void testString() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        String defaultValue = null;
        String[] values = new String[]{"", "hello", " x ", "\n"};
        try {
            Assert.assertEquals((String)"1.1", defaultValue, (Object)prefs.get("key1", defaultValue));
            int i = 0;
            while (i < values.length) {
                String v1 = values[i];
                String v2 = values[i] + "x";
                prefs.put("key1", v1);
                Assert.assertEquals((String)("1.2." + i), (Object)v1, (Object)prefs.get("key1", defaultValue));
                prefs.put("key1", v2);
                Assert.assertEquals((String)("1.3." + i), (Object)v2, (Object)prefs.get("key1", defaultValue));
                prefs.remove("key1");
                Assert.assertEquals((String)("1.4." + i), defaultValue, (Object)prefs.get("key1", defaultValue));
                ++i;
            }
            Assert.assertThrows(NullPointerException.class, () -> {
                String string2 = prefs.get(null, defaultValue);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.put(null, defaultValue));
            Assert.assertThrows(NullPointerException.class, () -> prefs.put("key1", null));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            String string2 = prefs.get("key1", defaultValue);
        });
    }

    @Test
    public void testLong() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        long defaultValue = 42L;
        long[] lArray = new long[5];
        lArray[0] = -12345L;
        lArray[2] = 12345L;
        lArray[3] = Long.MAX_VALUE;
        lArray[4] = Long.MIN_VALUE;
        long[] values = lArray;
        try {
            Assert.assertEquals((String)"1.1", (long)42L, (long)prefs.getLong("key1", 42L));
            int i = 0;
            while (i < values.length) {
                long v1 = values[i];
                long v2 = 54L;
                prefs.putLong("key1", v1);
                Assert.assertEquals((String)("1.2." + i), (long)v1, (long)prefs.getLong("key1", 42L));
                prefs.putLong("key1", v2);
                Assert.assertEquals((String)("1.3." + i), (long)v2, (long)prefs.getLong("key1", 42L));
                prefs.remove("key1");
                Assert.assertEquals((String)("1.4." + i), (long)42L, (long)prefs.getLong("key1", 42L));
                ++i;
            }
            String stringValue = "foo";
            prefs.put("key1", stringValue);
            Assert.assertEquals((String)"1.5", (Object)stringValue, (Object)prefs.get("key1", null));
            Assert.assertEquals((String)"1.6", (long)42L, (long)prefs.getLong("key1", 42L));
            Assert.assertThrows(NullPointerException.class, () -> {
                long l = prefs.getLong(null, 42L);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.putLong(null, 42L));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            long l = prefs.getLong("key1", 42L);
        });
    }

    @Test
    public void testBoolean() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        boolean defaultValue = false;
        try {
            Assert.assertEquals((String)"1.1", (Object)false, (Object)prefs.getBoolean("key1", false));
            prefs.putBoolean("key1", true);
            Assert.assertEquals((String)"1.2", (Object)true, (Object)prefs.getBoolean("key1", false));
            prefs.putBoolean("key1", false);
            Assert.assertEquals((String)"1.3", (Object)false, (Object)prefs.getBoolean("key1", false));
            prefs.remove("key1");
            Assert.assertEquals((String)"1.4", (Object)false, (Object)prefs.getBoolean("key1", false));
            String stringValue = "foo";
            prefs.put("key1", stringValue);
            Assert.assertEquals((String)"1.5", (Object)stringValue, (Object)prefs.get("key1", null));
            Assert.assertEquals((String)"1.6", (Object)false, (Object)prefs.getBoolean("key1", false));
            Assert.assertThrows(NullPointerException.class, () -> {
                boolean bl = prefs.getBoolean(null, false);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.putBoolean(null, false));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            boolean bl = prefs.getBoolean("key1", false);
        });
    }

    private byte[][] getByteValues() {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        result.add(new byte[0]);
        result.add(new byte[]{127});
        result.add(new byte[]{-128});
        result.add(new byte[1]);
        result.add(new byte[]{5});
        result.add(new byte[]{-23});
        return (byte[][])result.toArray((T[])new byte[result.size()][]);
    }

    @Test
    public void testBytes() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        byte[] defaultValue = new byte[]{42};
        byte[][] values = this.getByteValues();
        try {
            Assertions.assertThat((byte[])prefs.getByteArray("key1", defaultValue)).containsExactly(defaultValue);
            byte[][] byArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] value;
                byte[] v1 = value = byArray[n2];
                byte[] v2 = new byte[]{54};
                prefs.putByteArray("key1", v1);
                ((AbstractByteArrayAssert)Assertions.assertThat((byte[])prefs.getByteArray("key1", defaultValue)).as(value.toString(), new Object[0])).containsExactly(v1);
                prefs.putByteArray("key1", v2);
                ((AbstractByteArrayAssert)Assertions.assertThat((byte[])prefs.getByteArray("key1", defaultValue)).as(value.toString(), new Object[0])).containsExactly(v2);
                prefs.remove("key1");
                ((AbstractByteArrayAssert)Assertions.assertThat((byte[])prefs.getByteArray("key1", defaultValue)).as(value.toString(), new Object[0])).containsExactly(defaultValue);
                ++n2;
            }
            Assert.assertThrows(NullPointerException.class, () -> {
                byte[] byArray2 = prefs.getByteArray(null, defaultValue);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.putByteArray(null, defaultValue));
            Assert.assertThrows(NullPointerException.class, () -> prefs.putByteArray("key1", null));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            byte[] byArray2 = prefs.getByteArray("key1", defaultValue);
        });
    }

    @Test
    public void testFloat() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        float defaultValue = 42.0f;
        float[] values = new float[]{-12345.0f, 0.0f, 12345.0f, Float.MAX_VALUE, Float.MIN_VALUE};
        float tol = 1.0E-20f;
        try {
            Assert.assertEquals((String)"1.1", (float)42.0f, (float)prefs.getFloat("key1", 42.0f), (float)1.0E-20f);
            int i = 0;
            while (i < values.length) {
                float v1 = values[i];
                float v2 = 54.0f;
                prefs.putFloat("key1", v1);
                Assert.assertEquals((String)("1.2." + i), (float)v1, (float)prefs.getFloat("key1", 42.0f), (float)1.0E-20f);
                prefs.putFloat("key1", v2);
                Assert.assertEquals((String)("1.3." + i), (float)v2, (float)prefs.getFloat("key1", 42.0f), (float)1.0E-20f);
                prefs.remove("key1");
                Assert.assertEquals((String)("1.4." + i), (float)42.0f, (float)prefs.getFloat("key1", 42.0f), (float)1.0E-20f);
                ++i;
            }
            String stringValue = "foo";
            prefs.put("key1", stringValue);
            Assert.assertEquals((String)"1.5", (Object)stringValue, (Object)prefs.get("key1", null));
            Assert.assertEquals((String)"1.6", (float)42.0f, (float)prefs.getFloat("key1", 42.0f), (float)1.0E-20f);
            Assert.assertThrows(NullPointerException.class, () -> {
                float f = prefs.getFloat(null, 42.0f);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.putFloat(null, 42.0f));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            float f = prefs.getFloat("key1", 42.0f);
        });
    }

    @Test
    public void testFlushDeadlock() throws InterruptedException {
        String pluginId = "org.eclipse.core.tests.runtime";
        IEclipsePreferences parent = InstanceScope.INSTANCE.getNode(pluginId);
        Preferences child = parent.node("testFlushDeadlock");
        child.putBoolean("testFlushDeadlock", true);
        class FlushJob
        extends Job {
            private final Preferences node;
            private final /* synthetic */ String val$pluginId;

            FlushJob(Preferences node, String string) {
                this.val$pluginId = string;
                super("testFlushDeadlock");
                this.node = node;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.node.flush();
                }
                catch (BackingStoreException e) {
                    return new Status(4, this.val$pluginId, "unexpected flush failure", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }
        FlushJob flushParent = new FlushJob((Preferences)parent, pluginId);
        FlushJob flushChild = new FlushJob(child, pluginId);
        flushParent.schedule();
        flushChild.schedule();
        flushParent.join();
        flushChild.join();
    }

    @Test
    public void testDouble() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        double defaultValue = 42.0;
        double[] values = new double[]{0.0, 1002.5, -201788.55, Double.MAX_VALUE, Double.MIN_VALUE};
        double tol = 1.0E-20;
        try {
            Assert.assertEquals((String)"1.1", (double)42.0, (double)prefs.getDouble("key1", 42.0), (double)1.0E-20);
            int i = 0;
            while (i < values.length) {
                double v1 = values[i];
                double v2 = 54.0;
                prefs.putDouble("key1", v1);
                Assert.assertEquals((String)("1.2." + i), (double)v1, (double)prefs.getDouble("key1", 42.0), (double)1.0E-20);
                prefs.putDouble("key1", v2);
                Assert.assertEquals((String)("1.3." + i), (double)v2, (double)prefs.getDouble("key1", 42.0), (double)1.0E-20);
                prefs.remove("key1");
                Assert.assertEquals((String)("1.4." + i), (double)42.0, (double)prefs.getDouble("key1", 42.0), (double)1.0E-20);
                ++i;
            }
            String stringValue = "foo";
            prefs.put("key1", stringValue);
            Assert.assertEquals((String)"1.5", (Object)stringValue, (Object)prefs.get("key1", null));
            Assert.assertEquals((String)"1.6", (double)42.0, (double)prefs.getDouble("key1", 42.0), (double)1.0E-20);
            Assert.assertThrows(NullPointerException.class, () -> {
                double d = prefs.getDouble(null, 42.0);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.putDouble(null, 42.0));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            double d = prefs.getDouble("key1", 42.0);
        });
    }

    @Test
    public void testInt() throws BackingStoreException {
        String qualifier = EclipsePreferencesTest.getUniqueString();
        Preferences prefs = this.getScopeRoot().node(qualifier);
        String key = "key1";
        int defaultValue = 42;
        int[] nArray = new int[5];
        nArray[1] = 1002;
        nArray[2] = -201788;
        nArray[3] = Integer.MAX_VALUE;
        nArray[4] = Integer.MIN_VALUE;
        int[] values = nArray;
        try {
            Assert.assertEquals((String)"1.1", (long)42L, (long)prefs.getInt("key1", 42));
            int i = 0;
            while (i < values.length) {
                int v1 = values[i];
                int v2 = 54;
                prefs.putInt("key1", v1);
                Assert.assertEquals((String)("1.2." + i), (long)v1, (long)prefs.getInt("key1", 42));
                prefs.putInt("key1", v2);
                Assert.assertEquals((String)("1.3." + i), (long)v2, (long)prefs.getInt("key1", 42));
                prefs.remove("key1");
                Assert.assertEquals((String)("1.4." + i), (long)42L, (long)prefs.getInt("key1", 42));
                ++i;
            }
            String stringValue = "foo";
            prefs.put("key1", stringValue);
            Assert.assertEquals((String)"1.5", (Object)stringValue, (Object)prefs.get("key1", null));
            Assert.assertEquals((String)"1.6", (long)42L, (long)prefs.getInt("key1", 42));
            Assert.assertThrows(NullPointerException.class, () -> {
                int n = prefs.getInt(null, 42);
            });
            Assert.assertThrows(NullPointerException.class, () -> prefs.putInt(null, 42));
        }
        finally {
            prefs.removeNode();
        }
        Assert.assertThrows(IllegalStateException.class, () -> {
            int n = prefs.getInt("key1", 42);
        });
    }

    @Test
    public void testRemoveNode() throws BackingStoreException {
        Preferences node;
        IEclipsePreferences root = this.getScopeRoot();
        ArrayList<Preferences> list = new ArrayList<Preferences>();
        int i = 0;
        while (i < 5) {
            list.add(root.node(EclipsePreferencesTest.getUniqueString()));
            ++i;
        }
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            node = (Preferences)i2.next();
            Assert.assertTrue((String)("1." + String.valueOf(i2)), (boolean)node.nodeExists(""));
        }
        i2 = list.iterator();
        while (i2.hasNext()) {
            node = (Preferences)i2.next();
            node.removeNode();
            Assert.assertTrue((String)("2." + String.valueOf(i2)), (!node.nodeExists("") ? 1 : 0) != 0);
        }
    }

    @Test
    @Disabled(value="see bug 367366")
    public void _testRemoveDeletesFile() throws BackingStoreException {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("foo");
        Preferences parent = node.parent();
        node.put("a", "b");
        node.flush();
        File file = TestHelper.getInstanceBaseLocation().append(".settings").append("foo.prefs").toFile();
        Assert.assertTrue((String)"1.0", (boolean)file.exists());
        node.removeNode();
        parent.flush();
        Assert.assertFalse((String)"3.0", (boolean)file.exists());
    }

    @Test
    public void testName() {
        IEclipsePreferences node = Platform.getPreferencesService().getRootNode();
        Assert.assertEquals((String)"1.0", (Object)"", (Object)node.name());
        node = node.node("test");
        Assert.assertEquals((String)"2.0", (Object)"test", (Object)node.name());
        node = node.node("foo");
        Assert.assertEquals((String)"3.0", (Object)"foo", (Object)node.name());
    }

    @Test
    public void testNode() {
        IEclipsePreferences node = Platform.getPreferencesService().getRootNode();
        Assert.assertNotNull((String)"1.0", (Object)node);
        Assert.assertEquals((String)"1.1", (Object)"", (Object)node.name());
        Assert.assertEquals((String)"1.2", (Object)"/", (Object)node.absolutePath());
        Assert.assertEquals((String)"1.3", (Object)node, (Object)node.node("/"));
        node = node.node("test");
        Assert.assertNotNull((String)"2.0", (Object)node);
        Assert.assertEquals((String)"2.1", (Object)"test", (Object)node.name());
        Assert.assertEquals((String)"2.2", (Object)"/test", (Object)node.absolutePath());
        String name = EclipsePreferencesTest.getUniqueString();
        node = node.node(name);
        Assert.assertNotNull((String)"3.0", (Object)node);
        Assert.assertEquals((String)"3.1", (Object)name, (Object)node.name());
        Assert.assertEquals((String)"3.2", (Object)("/test/" + name), (Object)node.absolutePath());
    }

    @Test
    public void testParent() {
        Assert.assertNull((String)"1.0", (Object)Platform.getPreferencesService().getRootNode().parent());
        Preferences node = Platform.getPreferencesService().getRootNode().node("test");
        Preferences parent = node.parent();
        Assert.assertEquals((String)"2.0", (Object)"/", (Object)parent.absolutePath());
        node = this.getScopeRoot().node(EclipsePreferencesTest.getUniqueString());
        parent = node.parent();
        Assert.assertEquals((String)"2.0", (Object)"/test", (Object)parent.absolutePath());
    }

    @Test
    public void testKeys() throws BackingStoreException {
        Object[] keys = new String[]{"foo", "bar", "quux"};
        Preferences node = this.getScopeRoot().node(EclipsePreferencesTest.getUniqueString());
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            Assert.assertNull((String)("1.0." + i), (Object)node.get(key, null));
            ++i;
        }
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = objectArray[n2];
            node.put(key, EclipsePreferencesTest.getUniqueString());
            ++n2;
        }
        Object[] result = node.keys();
        Assertions.assertThat((Object[])keys).containsExactlyInAnyOrder(result);
    }

    @Test
    public void testChildrenNames() throws BackingStoreException {
        Object[] childrenNames = new String[]{"foo", "bar", "quux"};
        Preferences node = this.getScopeRoot().node(EclipsePreferencesTest.getUniqueString());
        Object[] result = null;
        result = node.childrenNames();
        Assertions.assertThat((Object[])result).isEmpty();
        Object[] objectArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childrenName = objectArray[n2];
            node.node(childrenName);
            ++n2;
        }
        result = node.childrenNames();
        Assertions.assertThat((Object[])childrenNames).containsExactlyInAnyOrder(result);
    }

    @Test
    public void testNodeExists() throws BackingStoreException {
        IEclipsePreferences parent = null;
        IEclipsePreferences node = Platform.getPreferencesService().getRootNode();
        String[] childrenNames = new String[]{"foo", "bar", "quux"};
        String fake = "fake";
        Assert.assertTrue((String)"1.0", (boolean)node.nodeExists(""));
        Assert.assertTrue((String)"1.1", (!node.nodeExists(fake) ? 1 : 0) != 0);
        parent = node;
        node = this.getScopeRoot();
        Assert.assertTrue((String)"2.0", (boolean)parent.nodeExists(node.name()));
        Assert.assertTrue((String)"2.1", (boolean)node.nodeExists(""));
        Assert.assertTrue((String)"2.2", (!parent.nodeExists(fake) ? 1 : 0) != 0);
        Assert.assertTrue((String)"2.3", (!node.nodeExists(fake) ? 1 : 0) != 0);
        parent = node;
        node = parent.node(EclipsePreferencesTest.getUniqueString());
        Assert.assertTrue((String)"3.0", (boolean)parent.nodeExists(node.name()));
        Assert.assertTrue((String)"3.1", (boolean)node.nodeExists(""));
        Assert.assertTrue((String)"3.2", (!parent.nodeExists(fake) ? 1 : 0) != 0);
        Assert.assertTrue((String)"3.3", (!node.nodeExists(fake) ? 1 : 0) != 0);
        parent = node;
        Preferences[] nodes = new Preferences[childrenNames.length];
        int i = 0;
        while (i < childrenNames.length) {
            nodes[i] = parent.node(childrenNames[i]);
            ++i;
        }
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childrenName = stringArray[n2];
            Assert.assertTrue((String)"4.0", (boolean)parent.nodeExists(childrenName));
            Assert.assertTrue((String)"4.1", (!parent.nodeExists(fake) ? 1 : 0) != 0);
            ++n2;
        }
        stringArray = nodes;
        n = nodes.length;
        n2 = 0;
        while (n2 < n) {
            String preferenceNode = stringArray[n2];
            Assert.assertTrue((String)"4.2", (boolean)preferenceNode.nodeExists(""));
            ++n2;
        }
        stringArray = nodes;
        n = nodes.length;
        n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            n3.removeNode();
            Assert.assertTrue((String)"5.1", (!parent.nodeExists(n3.name()) ? 1 : 0) != 0);
            Assert.assertTrue((String)"5.2", (!n3.nodeExists("") ? 1 : 0) != 0);
            ++n2;
        }
    }

    @Test
    public void testClear() throws BackingStoreException {
        Preferences node = this.getScopeRoot().node(EclipsePreferencesTest.getUniqueString());
        Object[] keys = new String[]{"foo", "bar", "quux"};
        String[] values = new String[]{EclipsePreferencesTest.getUniqueString(), EclipsePreferencesTest.getUniqueString(), EclipsePreferencesTest.getUniqueString()};
        Assertions.assertThat((Object[])node.keys()).isEmpty();
        int i = 0;
        while (i < keys.length) {
            node.put((String)keys[i], values[i]);
            ++i;
        }
        Assertions.assertThat((Object[])keys).containsExactlyInAnyOrder((Object[])node.keys());
        node.clear();
        Assertions.assertThat((Object[])node.keys()).isEmpty();
        i = 0;
        while (i < keys.length) {
            Assert.assertNull((String)("3.1." + i), (Object)node.get((String)keys[i], null));
            ++i;
        }
    }

    @Test
    public void testAbsolutePath() {
        IPath expected = IPath.ROOT;
        IEclipsePreferences node = Platform.getPreferencesService().getRootNode();
        Assert.assertEquals((String)"1.0", (Object)expected.toString(), (Object)node.absolutePath());
        expected = expected.append("test");
        node = node.node("test");
        Assert.assertEquals((String)"2.0", (Object)expected.toString(), (Object)node.absolutePath());
        String name = EclipsePreferencesTest.getUniqueString();
        expected = expected.append(name);
        node = node.node(name);
        Assert.assertEquals((String)"3.0", (Object)expected.toString(), (Object)node.absolutePath());
    }

    @Test
    public void testAccept() throws BackingStoreException {
        IEclipsePreferences scopeRoot = this.getScopeRoot();
        ArrayList<Object> expected = new ArrayList<Object>();
        ArrayList actual = new ArrayList();
        IPreferenceNodeVisitor visitor = node -> {
            actual.add(node.absolutePath());
            return true;
        };
        scopeRoot.accept(visitor);
        expected.add(scopeRoot.absolutePath());
        Assertions.assertThat(actual).containsExactlyInAnyOrderElementsOf(actual);
        HashSet<String> children = new HashSet<String>();
        children.add(EclipsePreferencesTest.getUniqueString());
        children.add(EclipsePreferencesTest.getUniqueString());
        children.add(EclipsePreferencesTest.getUniqueString());
        actual.clear();
        expected.clear();
        expected.add(scopeRoot.absolutePath());
        for (String s : children) {
            expected.add(scopeRoot.absolutePath() + "/" + s);
            scopeRoot.node(s);
        }
        scopeRoot.accept(visitor);
        Assertions.assertThat(actual).containsExactlyInAnyOrderElementsOf(expected);
    }

    @Test
    public void testPreferenceChangeListeners() {
        IEclipsePreferences node = this.getScopeRoot();
        PreferenceTracer tracer = new PreferenceTracer();
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)tracer);
        String key = "foo";
        Assert.assertEquals((String)"0.0", (Object)"", (Object)tracer.log.toString());
        node.put(key, "bar");
        String string = node.get(key, null);
        Assert.assertNotNull((String)"1.0", (Object)string);
        Assert.assertEquals((String)"1.1", (Object)"bar", (Object)string);
        Assert.assertEquals((String)"1.2", (Object)"[foo:null->Sbar]", (Object)tracer.log.toString());
        tracer.log.setLength(0);
        node.put(key, "quux");
        string = node.get(key, null);
        Assert.assertNotNull((String)"2.0", (Object)string);
        Assert.assertEquals((String)"2.1", (Object)"quux", (Object)string);
        Assert.assertEquals((String)"2.2", (Object)"[foo:Sbar->Squux]", (Object)tracer.log.toString());
        tracer.log.setLength(0);
        node.putInt(key, 123);
        int i = node.getInt(key, 0);
        Assert.assertEquals((String)"3.0", (long)123L, (long)i);
        Assert.assertEquals((String)"3.1", (Object)"[foo:Squux->S123]", (Object)tracer.log.toString());
        node.put(key, "aaa");
        tracer.log.setLength(0);
        node.remove(key);
        Assert.assertNull((String)"4.0", (Object)node.get(key, null));
        Assert.assertEquals((String)"4.1", (Object)"[foo:Saaa->null]", (Object)tracer.log.toString());
    }

    @Test
    public void testNodeChangeListeners() throws BackingStoreException {
        IEclipsePreferences root = this.getScopeRoot();
        NodeTracer tracer = new NodeTracer();
        root.addNodeChangeListener((IEclipsePreferences.INodeChangeListener)tracer);
        Assert.assertEquals((String)"0.0", (Object)"", (Object)tracer.log.toString());
        String name = EclipsePreferencesTest.getUniqueString();
        IPath parent = IPath.fromOSString((String)root.absolutePath());
        IPath child = parent.append(name);
        Preferences node = root.node(name);
        Assert.assertEquals((String)"1.0", (Object)("[A:" + String.valueOf(parent) + "," + String.valueOf(child) + "]"), (Object)tracer.log.toString());
        tracer.log.setLength(0);
        node.removeNode();
        Assert.assertEquals((String)"2.0", (Object)("[R:" + String.valueOf(parent) + "," + String.valueOf(child) + "]"), (Object)tracer.log.toString());
        root.removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)tracer);
        tracer.log.setLength(0);
        root.node(name);
        Assert.assertEquals((String)"3.0", (Object)"", (Object)tracer.log.toString());
    }

    @Test
    public void test_60590() throws BackingStoreException {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String one = EclipsePreferencesTest.getUniqueString();
        String two = EclipsePreferencesTest.getUniqueString();
        String threeA = EclipsePreferencesTest.getUniqueString();
        String threeB = EclipsePreferencesTest.getUniqueString();
        String key = "key";
        String value = "value";
        Preferences node = root.node("test").node(one).node(two).node(threeA);
        node.put(key, value);
        node.flush();
        node = root.node("test").node(one).node(two).node(threeB);
        node.put(key, value);
        Preferences current = node;
        int count = 0;
        while (current != null && current instanceof EclipsePreferences && current.parent() != null && IPath.fromOSString((String)current.absolutePath()).segment(0).equals("test")) {
            Assert.assertTrue((String)("1.0." + current.absolutePath()), (boolean)((EclipsePreferences)current).isDirty());
            ++count;
            current = current.parent();
        }
        Assert.assertEquals((String)("2.0." + count), (long)4L, (long)count);
    }

    @Test
    public void test_342709() throws Exception {
        IEclipsePreferences root = Platform.getPreferencesService().getRootNode();
        String one = EclipsePreferencesTest.getUniqueString();
        String two = EclipsePreferencesTest.getUniqueString();
        String three = EclipsePreferencesTest.getUniqueString();
        String key = "key";
        String value = "value";
        Preferences node = root.node("test2").node(one).node(two).node(three);
        node.put(key, value);
        node.flush();
        Assert.assertTrue((String)"2.0", (boolean)(node instanceof TestScope2));
        IPath location = ((TestScope2)node).getLocation();
        Collection<String> lines = null;
        lines = EclipsePreferencesTest.read(location);
        for (String line : lines) {
            Assert.assertFalse((String)("3." + line), (boolean)line.startsWith("#"));
        }
    }

    public static Collection<String> read(IPath location) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader fileReader = new FileReader(location.toFile());){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (BufferedReader reader = new BufferedReader(fileReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return result;
    }

    @Test
    public void test_55410() {
        String[] keys = new String[]{"my/key", "my:key", "my/long:key"};
        String[] paths = new String[]{"my/path", "my:path"};
        Preferences node = Platform.getPreferencesService().getRootNode().node("test").node(EclipsePreferencesTest.getUniqueString());
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = EclipsePreferencesTest.getUniqueString();
            node.put(key, value);
            Assert.assertEquals((String)("1.0." + key), (Object)value, (Object)node.get(key, null));
            ++n2;
        }
        String root = node.absolutePath();
        String[] stringArray2 = paths;
        int n3 = paths.length;
        n = 0;
        while (n < n3) {
            String path = stringArray2[n];
            String expected = root + "/" + path;
            String actual = node.node(path).absolutePath();
            Assert.assertEquals((String)("2.0." + path), (Object)expected, (Object)actual);
            ++n;
        }
    }

    @Test
    public void testFileFormat() throws BackingStoreException {
        ArrayList<Info> list = new ArrayList<Info>();
        class Info {
            String path;
            String key;
            String encoded;

            Info(String path, String key, String encoded) {
                this.path = path;
                this.key = key;
                this.encoded = encoded;
            }
        }
        list.add(new Info("", "a", "a"));
        list.add(new Info("", "/a", "///a"));
        list.add(new Info("a", "b", "a/b"));
        list.add(new Info("a/b", "c/d", "a/b//c/d"));
        list.add(new Info("", "a//b", "//a//b"));
        list.add(new Info("a/b", "c", "a/b/c"));
        list.add(new Info("a/b", "c//d", "a/b//c//d"));
        IEclipsePreferences node = new TestScope().getNode(EclipsePreferencesTest.getUniqueString());
        int i = 0;
        while (i < list.size()) {
            Info info = (Info)list.get(i);
            node.node(info.path).put(info.key, Integer.toString(i));
            ++i;
        }
        Assert.assertTrue((String)"0.8", (boolean)(node instanceof EclipsePreferences));
        Properties properties = null;
        properties = TestHelper.convertToProperties((EclipsePreferences)((EclipsePreferences)node), (String)"");
        for (Object object : properties.keySet()) {
            String key = (String)object;
            String value = properties.getProperty(key);
            Info info = (Info)list.get(Integer.parseInt(value));
            Assert.assertNotNull((String)"2.0", (Object)info);
            Assert.assertEquals((String)("2.1." + key), (Object)info.encoded, (Object)key);
        }
    }

    private Properties loadProperties(IPath location) throws FileNotFoundException, IOException {
        Properties result = new Properties();
        if (!location.toFile().exists()) {
            return result;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream input = new FileInputStream(location.toFile());){
            result.load(input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Test
    public void testEncodePath() {
        ArrayList<Item> list = new ArrayList<Item>();
        class Item {
            String path;
            String key;
            String expected;

            Item(String path, String key, String expected) {
                this.path = path;
                this.key = key;
                this.expected = expected;
            }
        }
        list.add(new Item(null, "a", "a"));
        list.add(new Item(null, "/a", "///a"));
        list.add(new Item("a", "b", "a/b"));
        list.add(new Item("a/b", "c/d", "a/b//c/d"));
        list.add(new Item("a", "b//c", "a//b//c"));
        list.add(new Item("repositories", "cvs://dev.eclipse.org:25/cvsroot", "repositories//cvs://dev.eclipse.org:25/cvsroot"));
        list.add(new Item("repositories:cvs", "dev.eclipse.org:25", "repositories:cvs/dev.eclipse.org:25"));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Item item = (Item)i.next();
            Assert.assertEquals((String)("a" + String.valueOf(i) + item.expected), (Object)item.expected, (Object)EclipsePreferences.encodePath((String)item.path, (String)item.key));
            String[] result = EclipsePreferences.decodePath((String)item.expected);
            Assert.assertEquals((String)("b" + String.valueOf(i) + item.path), (Object)item.path, (Object)result[0]);
            Assert.assertEquals((String)("c" + String.valueOf(i) + item.key), (Object)item.key, (Object)result[1]);
        }
    }

    @Test
    public void testGetSegment() {
        String[][] stringArrayArray = new String[12][];
        stringArrayArray[0] = new String[]{"instance", "/instance/foo", "0"};
        stringArrayArray[1] = new String[]{"instance", "instance/foo", "0"};
        stringArrayArray[2] = new String[]{"instance", "instance", "0"};
        stringArrayArray[3] = new String[]{"instance", "instance", "0"};
        stringArrayArray[4] = new String[]{"foo", "/instance/foo", "1"};
        stringArrayArray[5] = new String[]{"foo", "instance/foo", "1"};
        stringArrayArray[6] = new String[]{"foo", "/instance/foo/", "1"};
        stringArrayArray[7] = new String[]{"foo", "instance/foo/", "1"};
        stringArrayArray[8] = new String[]{"foo", "/instance/foo/bar", "1"};
        String[] stringArray = new String[3];
        stringArray[1] = "/instance";
        stringArray[2] = "1";
        stringArrayArray[9] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[1] = "instance";
        stringArray2[2] = "1";
        stringArrayArray[10] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[1] = "instance/";
        stringArray3[2] = "1";
        stringArrayArray[11] = stringArray3;
        String[][] data = stringArrayArray;
        int i = 0;
        while (i < data.length) {
            String[] line = data[i];
            Assert.assertEquals((String)("1.0." + i + ":" + line[1] + " (" + line[2] + ")"), (Object)line[0], (Object)EclipsePreferences.getSegment((String)line[1], (int)Integer.parseInt(line[2])));
            ++i;
        }
    }

    @Test
    public void testGetSegmentCount() {
        String[][] data;
        String[][] stringArrayArray = data = new String[][]{{"/instance/foo", "2"}, {"instance/foo", "2"}, {"/instance/foo/", "2"}, {"/instance", "1"}, {"instance", "1"}, {"/instance/", "1"}, {"instance/", "1"}};
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArrayArray[n2];
            Assert.assertEquals((String)("1.0:" + line[0]), (long)Integer.parseInt(line[1]), (long)EclipsePreferences.getSegmentCount((String)line[0]));
            ++n2;
        }
    }

    @Test
    public void test_68897() throws Exception {
        Path file = FileSystemHelper.getRandomLocation().toPath();
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences rootPreferences = service.getRootNode();
        Preferences pref = rootPreferences.node("/favorite");
        Preferences child = pref.node("my");
        child.put("file", "my.txt");
        child.flush();
        pref.flush();
        rootPreferences.flush();
        Throwable throwable = null;
        Object var7_9 = null;
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            service.exportPreferences(rootPreferences, outputStream, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var7_9 = null;
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            IExportedPreferences epref = service.readPreferences(inputStream);
            service.applyPreferences(epref);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetByteArray() {
        byte[] testArray = new byte[]{10, 13, 15, 20};
        IScopeContext defaultScope = DefaultScope.INSTANCE;
        defaultScope.getNode(this.TEST_NODE_PATH).putByteArray(this.TEST_PREF_KEY, testArray);
        byte[] returnArray = Platform.getPreferencesService().getByteArray(this.TEST_NODE_PATH, this.TEST_PREF_KEY, new byte[0], null);
        Assertions.assertThat((byte[])returnArray).isEqualTo((Object)testArray);
    }

    @Test
    public void testNode3() throws Exception {
        Object child;
        String[] children;
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences rootPreferences = service.getRootNode();
        Preferences node = rootPreferences.node("test3");
        File file = RuntimeTestsPlugin.getTestData("testData/preferences/test3");
        List<String> expectedChildren = Arrays.asList(file.list());
        String[] stringArray = children = node.childrenNames();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = stringArray[n2];
            Assert.assertTrue((String)("1.1." + (String)child), (boolean)expectedChildren.contains(child));
            ++n2;
        }
        child = node.node("foo");
        Assertions.assertThat((Object[])child.keys()).hasSize(2);
        Assert.assertEquals((String)"2.1", (Object)"value1", (Object)child.get("key1", null));
        Assert.assertEquals((String)"2.2", (Object)"value2", (Object)child.get("key2", null));
        child.put("key8", "value8");
        child.flush();
        String prop = System.getProperty("equinox.preference.test.TestNodeStorage3,root");
        Assert.assertNotNull((String)"3.1", (Object)prop);
        File rootFile = new File(prop);
        File childFile = new File(rootFile, "foo");
        Assert.assertTrue((String)"3.2", (boolean)childFile.exists());
        Properties contents = this.loadProperties(IPath.fromOSString((String)childFile.getAbsolutePath()));
        Assert.assertEquals((String)"3.3", (Object)"value8", (Object)contents.getProperty("key8", null));
        child.removeNode();
        Assert.assertFalse((String)"4.1", (boolean)childFile.exists());
    }

    private static String getUniqueString() {
        return UUID.randomUUID().toString();
    }

    static class NodeTracer
    implements IEclipsePreferences.INodeChangeListener {
        StringBuilder log = new StringBuilder();

        NodeTracer() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            this.log.append("[A:");
            this.log.append(event.getParent().absolutePath());
            this.log.append(',');
            this.log.append(event.getChild().absolutePath());
            this.log.append(']');
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            this.log.append("[R:");
            this.log.append(event.getParent().absolutePath());
            this.log.append(',');
            this.log.append(event.getChild().absolutePath());
            this.log.append(']');
        }
    }

    static class PreferenceTracer
    implements IEclipsePreferences.IPreferenceChangeListener {
        public StringBuilder log = new StringBuilder();

        PreferenceTracer() {
        }

        private String typeCode(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Boolean) {
                return "B";
            }
            if (value instanceof Integer) {
                return "I";
            }
            if (value instanceof Long) {
                return "L";
            }
            if (value instanceof Float) {
                return "F";
            }
            if (value instanceof Double) {
                return "D";
            }
            if (value instanceof String) {
                return "S";
            }
            if (value instanceof byte[]) {
                return "b";
            }
            Assert.assertTrue((String)("0.0: " + String.valueOf(value)), (boolean)false);
            return null;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.log.append("[");
            this.log.append(event.getKey());
            this.log.append(":");
            this.log.append(this.typeCode(event.getOldValue()));
            this.log.append(event.getOldValue() == null ? "null" : event.getOldValue());
            this.log.append("->");
            this.log.append(this.typeCode(event.getNewValue()));
            this.log.append(event.getNewValue() == null ? "null" : event.getNewValue());
            this.log.append("]");
        }
    }
}

