/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.internal.preferences.BadTestScope;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class IScopeContextTest {
    @Test
    public void testGetNode() {
        IScopeContext context = InstanceScope.INSTANCE;
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            IEclipsePreferences iEclipsePreferences = context.getNode(null);
        });
        String qualifier = Long.toString(System.currentTimeMillis());
        IEclipsePreferences node = context.getNode(qualifier);
        Assert.assertNotNull((String)"2.0", (Object)node);
        String expected = "/instance/" + qualifier;
        String actual = node.absolutePath();
        Assert.assertEquals((String)"2.1", (Object)expected, (Object)actual);
        qualifier = IPath.fromOSString((String)Long.toString(System.currentTimeMillis())).append("a").toString();
        node = context.getNode(qualifier);
        Assert.assertNotNull((String)"3.0", (Object)node);
        expected = "/instance/" + qualifier;
        actual = node.absolutePath();
        Assert.assertEquals((String)"3.1", (Object)expected, (Object)actual);
    }

    @Test
    public void testBadContext() {
        BadTestScope context = new BadTestScope();
        IPreferencesService service = Platform.getPreferencesService();
        Assert.assertThrows(RuntimeException.class, () -> {
            IEclipsePreferences iEclipsePreferences = context.getNode("qualifier");
        });
        Assert.assertNull((String)"1.0", (Object)service.getString("qualifier", "foo", null, new IScopeContext[]{context}));
    }
}

